/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.BufferFactory;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.InMemoryBufferFactory;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.LocalFileBufferFactory;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.MultipartBufferFactory;

public enum BufferTypeOptions {
    INMEMORY("in_memory", new InMemoryBufferFactory()),
    LOCALFILE("local_file", new LocalFileBufferFactory()),
    MULTI_PART("multipart", new MultipartBufferFactory());

    private final String option;
    private final BufferFactory bufferType;
    private static final Map<String, BufferTypeOptions> OPTIONS_MAP;

    private BufferTypeOptions(String option, BufferFactory bufferType) {
        this.option = option.toLowerCase();
        this.bufferType = bufferType;
    }

    public BufferFactory getBufferFactory() {
        return this.bufferType;
    }

    @JsonCreator
    static BufferTypeOptions fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(BufferTypeOptions.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

