/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.Arrays;
import java.util.Random;

public class LowNoisePeriodic
implements Example {
    public static void main(String[] args) throws Exception {
        new LowNoisePeriodic().run();
    }

    @Override
    public String command() {
        return "Thresholded_Multi_Dim_example with low noise";
    }

    @Override
    public String description() {
        return "Thresholded Multi Dimensional Example with Low Noise";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 8;
        int numberOfTrees = 50;
        int sampleSize = 256;
        int dataSize = 100000;
        int initialSegment = 100;
        double[] reference = new double[]{1.0, 3.0, 5.0, 7.0, 9.0, 11.0, 9.5, 8.5, 7.5, 6.5, 6.0, 6.5, 7.0, 7.5, 9.5, 11.0, 12.5, 10.5, 8.5, 7.0, 5.0, 3.0, 2.0, 1.0};
        double noise = 0.25;
        double anomalyFactor = 10.0;
        double slope = 0.2 * (double)sampleSize * (Arrays.stream(reference).max().getAsDouble() - Arrays.stream(reference).min().getAsDouble()) / 50000.0;
        slope = 0.0;
        double anomalyRate = 0.005;
        long seed = new Random().nextLong();
        System.out.println(" Seed " + seed);
        Random rng = new Random(seed);
        int numAnomalies = 0;
        int incorrectlyFlagged = 0;
        int correct = 0;
        int late = 0;
        TransformMethod method = TransformMethod.NORMALIZE;
        int dimensions = shingleSize;
        ThresholdedRandomCutForest forest = ThresholdedRandomCutForest.builder().dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).anomalyRate(0.01).forestMode(ForestMode.STANDARD).startNormalization(32).transformMethod(method).outputAfter(32).initialAcceptFraction(0.125).weights(new double[]{1.0}).build();
        double[] value = new double[]{0.0};
        int lastAnomaly = 0;
        for (int count = 0; count < dataSize; ++count) {
            double intendedValue;
            boolean anomaly = false;
            value[0] = intendedValue = reference[(count + 4) % reference.length] + slope * (double)count;
            if (rng.nextDouble() < anomalyRate && count > initialSegment) {
                double anomalyValue = noise * anomalyFactor * (1.0 + rng.nextDouble());
                value[0] = value[0] + (rng.nextDouble() < 0.5 ? -anomalyValue : anomalyValue);
                anomaly = true;
                ++numAnomalies;
            } else {
                value[0] = value[0] + (2.0 * rng.nextDouble() - 1.0) * noise;
            }
            AnomalyDescriptor result = forest.process(new double[]{value[0]}, 0L);
            if (result.getAnomalyGrade() > 0.0) {
                System.out.print(count + " " + result.getAnomalyGrade() + " ");
                if (result.getRelativeIndex() < 0) {
                    System.out.print((lastAnomaly == count + result.getRelativeIndex()) + " " + -result.getRelativeIndex() + " steps ago,");
                    if (lastAnomaly == count + result.getRelativeIndex()) {
                        ++late;
                    } else {
                        ++incorrectlyFlagged;
                    }
                } else {
                    System.out.print(anomaly);
                    if (anomaly) {
                        ++correct;
                    } else {
                        ++incorrectlyFlagged;
                    }
                }
                System.out.print(" current value " + value[0]);
                if (result.isExpectedValuesPresent()) {
                    System.out.print(" expected " + result.getExpectedValuesList()[0][0] + " instead of  " + result.getPastValues()[0]);
                }
                System.out.print(" score " + result.getRCFScore() + " threshold " + result.getThreshold());
                System.out.println();
            } else if (anomaly) {
                System.out.println(count + " missed current value " + value[0] + ", intended " + intendedValue + ", score " + result.getRCFScore() + ", threshold " + result.getThreshold());
            }
            if (!anomaly) continue;
            lastAnomaly = count;
        }
        System.out.println("Anomalies " + numAnomalies + ",  correct " + correct + ", late " + late + ", incorrectly flagged " + incorrectlyFlagged);
    }
}

