/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartition;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotFoundException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionNotOwnedException;
import org.opensearch.dataprepper.model.source.coordinator.exceptions.PartitionUpdateException;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchIndexProgressState;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.SearchConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.metrics.OpenSearchSourcePluginMetrics;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.OpenSearchIndexPartitionCreationSupplier;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.SearchWorker;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.WorkerCommonUtils;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.exceptions.IndexNotFoundException;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.exceptions.SearchContextLimitException;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.CreatePointInTimeRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.CreatePointInTimeResponse;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.DeletePointInTimeRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchPointInTimeRequest;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchWithSearchAfterResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PitWorker
implements SearchWorker,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PitWorker.class);
    static final String STARTING_KEEP_ALIVE = "15m";
    private static final Duration STARTING_KEEP_ALIVE_DURATION = Duration.ofMinutes(15L);
    static final String EXTEND_KEEP_ALIVE_TIME = "1m";
    private static final Duration EXTEND_KEEP_ALIVE_DURATION = Duration.ofMinutes(1L);
    private final ObjectMapper objectMapper;
    private final SearchAccessor searchAccessor;
    private final OpenSearchSourceConfiguration openSearchSourceConfiguration;
    private final SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator;
    private final BufferAccumulator<Record<Event>> bufferAccumulator;
    private final OpenSearchIndexPartitionCreationSupplier openSearchIndexPartitionCreationSupplier;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics;
    private int noAvailableIndicesCount = 0;

    public PitWorker(ObjectMapper objectMapper, SearchAccessor searchAccessor, OpenSearchSourceConfiguration openSearchSourceConfiguration, SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator, BufferAccumulator<Record<Event>> bufferAccumulator, OpenSearchIndexPartitionCreationSupplier openSearchIndexPartitionCreationSupplier, AcknowledgementSetManager acknowledgementSetManager, OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics) {
        this.objectMapper = objectMapper;
        this.searchAccessor = searchAccessor;
        this.sourceCoordinator = sourceCoordinator;
        this.openSearchSourceConfiguration = openSearchSourceConfiguration;
        this.bufferAccumulator = bufferAccumulator;
        this.openSearchIndexPartitionCreationSupplier = openSearchIndexPartitionCreationSupplier;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.openSearchSourcePluginMetrics = openSearchSourcePluginMetrics;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Optional indexPartition = this.sourceCoordinator.getNextPartition((Function)this.openSearchIndexPartitionCreationSupplier);
                if (indexPartition.isEmpty()) {
                    try {
                        Thread.sleep(WorkerCommonUtils.calculateExponentialBackoffAndJitter(++this.noAvailableIndicesCount));
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.info("The PitWorker was interrupted while sleeping after acquiring no indices to process, stopping processing");
                        return;
                    }
                }
                this.noAvailableIndicesCount = 0;
                try {
                    AcknowledgementSet acknowledgementSet = WorkerCommonUtils.createAcknowledgmentSet(this.acknowledgementSetManager, this.openSearchSourceConfiguration, this.sourceCoordinator, (SourcePartition<OpenSearchIndexProgressState>)((SourcePartition)indexPartition.get()));
                    this.openSearchSourcePluginMetrics.getIndexProcessingTimeTimer().record(() -> this.processIndex((SourcePartition<OpenSearchIndexProgressState>)((SourcePartition)indexPartition.get()), acknowledgementSet));
                    WorkerCommonUtils.completeIndexPartition(this.openSearchSourceConfiguration, acknowledgementSet, (SourcePartition<OpenSearchIndexProgressState>)((SourcePartition)indexPartition.get()), this.sourceCoordinator);
                    this.openSearchSourcePluginMetrics.getIndicesProcessedCounter().increment();
                }
                catch (PartitionNotFoundException | PartitionNotOwnedException | PartitionUpdateException e) {
                    LOG.warn("PitWorker received an exception from the source coordinator. There is a potential for duplicate data for index {}, giving up partition and getting next partition: {}", (Object)((SourcePartition)indexPartition.get()).getPartitionKey(), (Object)e.getMessage());
                    this.sourceCoordinator.giveUpPartition(((SourcePartition)indexPartition.get()).getPartitionKey());
                }
                catch (SearchContextLimitException e) {
                    LOG.warn("Received SearchContextLimitExceeded exception for index {}. Giving up index and waiting {} seconds before retrying: {}", new Object[]{((SourcePartition)indexPartition.get()).getPartitionKey(), WorkerCommonUtils.BACKOFF_ON_EXCEPTION.getSeconds(), e.getMessage()});
                    this.sourceCoordinator.giveUpPartition(((SourcePartition)indexPartition.get()).getPartitionKey());
                    this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                    try {
                        Thread.sleep(WorkerCommonUtils.BACKOFF_ON_EXCEPTION.toMillis());
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                catch (IndexNotFoundException e) {
                    LOG.warn("{}, marking index as complete and continuing processing", (Object)e.getMessage());
                    this.sourceCoordinator.completePartition(((SourcePartition)indexPartition.get()).getPartitionKey(), Boolean.valueOf(false));
                }
                catch (RuntimeException e) {
                    LOG.error("Unknown exception while processing index '{}':", (Object)((SourcePartition)indexPartition.get()).getPartitionKey(), (Object)e);
                    this.sourceCoordinator.giveUpPartition(((SourcePartition)indexPartition.get()).getPartitionKey());
                    this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                }
            }
            catch (Exception e) {
                LOG.error("Received an exception while trying to get index to process with PIT, backing off and retrying", (Throwable)e);
                this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                try {
                    Thread.sleep(WorkerCommonUtils.BACKOFF_ON_EXCEPTION.toMillis());
                }
                catch (InterruptedException ex) {
                    LOG.info("The PitWorker was interrupted before backing off and retrying, stopping processing");
                    return;
                }
            }
        }
    }

    private void processIndex(SourcePartition<OpenSearchIndexProgressState> openSearchIndexPartition, AcknowledgementSet acknowledgementSet) {
        OpenSearchIndexProgressState openSearchIndexProgressState;
        String indexName = openSearchIndexPartition.getPartitionKey();
        long lastCheckpointTime = System.currentTimeMillis();
        LOG.info("Starting processing for index: '{}'", (Object)indexName);
        Optional<OpenSearchIndexProgressState> openSearchIndexProgressStateOptional = openSearchIndexPartition.getPartitionState();
        if (this.openSearchSourceConfiguration.isAcknowledgmentsEnabled().booleanValue() || openSearchIndexProgressStateOptional.isEmpty()) {
            openSearchIndexProgressStateOptional = Optional.of(this.initializeProgressState());
        }
        if (!(openSearchIndexProgressState = openSearchIndexProgressStateOptional.get()).hasValidPointInTime()) {
            CreatePointInTimeResponse createPointInTimeResponse = this.searchAccessor.createPit(CreatePointInTimeRequest.builder().withIndex(indexName).withKeepAlive(STARTING_KEEP_ALIVE).build());
            LOG.debug("Created point in time for index {} with pit id {}", (Object)indexName, (Object)createPointInTimeResponse.getPitId());
            openSearchIndexProgressState.setPitId(createPointInTimeResponse.getPitId());
            openSearchIndexProgressState.setPitCreationTime(createPointInTimeResponse.getPitCreationTime());
            openSearchIndexProgressState.setKeepAlive(STARTING_KEEP_ALIVE_DURATION.toMillis());
            openSearchIndexProgressState.setSearchAfter(null);
        }
        SearchConfiguration searchConfiguration = this.openSearchSourceConfiguration.getSearchConfiguration();
        SearchWithSearchAfterResults searchWithSearchAfterResults = null;
        do {
            searchWithSearchAfterResults = this.searchAccessor.searchWithPit(SearchPointInTimeRequest.builder().withPitId(openSearchIndexProgressState.getPitId()).withKeepAlive(EXTEND_KEEP_ALIVE_TIME).withPaginationSize(searchConfiguration.getBatchSize()).withSearchAfter(this.getSearchAfter(openSearchIndexProgressState, searchWithSearchAfterResults)).build());
            searchWithSearchAfterResults.getDocuments().stream().map(Record::new).forEach(record -> {
                try {
                    long documentBytes = this.objectMapper.writeValueAsBytes((Object)((Event)record.getData()).getJsonNode()).length;
                    this.openSearchSourcePluginMetrics.getBytesReceivedSummary().record((double)documentBytes);
                    if (Objects.nonNull(acknowledgementSet)) {
                        acknowledgementSet.add((Event)record.getData());
                    }
                    this.bufferAccumulator.add(record);
                    this.openSearchSourcePluginMetrics.getDocumentsProcessedCounter().increment();
                    this.openSearchSourcePluginMetrics.getBytesProcessedSummary().record((double)documentBytes);
                }
                catch (Exception e) {
                    this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
                    LOG.error("Failed writing OpenSearch documents to buffer. The last document created has document id '{}' from index '{}' : {}", new Object[]{((Event)record.getData()).getMetadata().getAttribute("opensearch-document_id"), ((Event)record.getData()).getMetadata().getAttribute("opensearch-index"), e.getMessage()});
                }
            });
            openSearchIndexProgressState.setSearchAfter(searchWithSearchAfterResults.getNextSearchAfter());
            openSearchIndexProgressState.setKeepAlive(Duration.ofMillis(openSearchIndexProgressState.getKeepAlive()).plus(EXTEND_KEEP_ALIVE_DURATION).toMillis());
            if (System.currentTimeMillis() - lastCheckpointTime <= 300000L) continue;
            LOG.debug("Renew ownership of index {}", (Object)indexName);
            this.sourceCoordinator.saveProgressStateForPartition(indexName, (Object)openSearchIndexProgressState);
            lastCheckpointTime = System.currentTimeMillis();
        } while (searchWithSearchAfterResults.getDocuments().size() == searchConfiguration.getBatchSize().intValue());
        try {
            this.bufferAccumulator.flush();
        }
        catch (Exception e) {
            this.openSearchSourcePluginMetrics.getProcessingErrorsCounter().increment();
            LOG.error("Failed flushing remaining OpenSearch documents to buffer due to: {}", (Object)e.getMessage());
        }
        this.searchAccessor.deletePit(DeletePointInTimeRequest.builder().withPitId(openSearchIndexProgressState.getPitId()).build());
    }

    private OpenSearchIndexProgressState initializeProgressState() {
        return new OpenSearchIndexProgressState();
    }

    private List<String> getSearchAfter(OpenSearchIndexProgressState openSearchIndexProgressState, SearchWithSearchAfterResults searchWithSearchAfterResults) {
        if (Objects.isNull(searchWithSearchAfterResults)) {
            if (Objects.isNull(openSearchIndexProgressState.getSearchAfter())) {
                return null;
            }
            return openSearchIndexProgressState.getSearchAfter();
        }
        return searchWithSearchAfterResults.getNextSearchAfter();
    }
}

