/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchContextType;

public class SearchConfiguration {
    @JsonProperty(value="search_context_type")
    private String searchContextType;
    @JsonProperty(value="batch_size")
    private Integer batchSize = 1000;
    @JsonIgnore
    private SearchContextType searchContextTypeValue;

    public SearchContextType getSearchContextType() {
        return this.searchContextTypeValue;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    @AssertTrue(message="search_context_type must be one of [ 'scroll', 'point_in_time', 'none' ]")
    @AssertTrue(message="search_context_type must be one of [ 'scroll', 'point_in_time', 'none' ]") boolean isSearchContextTypeValid() {
        try {
            if (this.searchContextType != null) {
                this.searchContextTypeValue = SearchContextType.valueOf(this.searchContextType.toUpperCase());
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

