/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.configuration;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.certificate.validation.PemObjectValidator;

public class ConnectionConfiguration {
    @Deprecated
    @JsonProperty(value="cert")
    private Path certPath;
    @JsonAlias(value={"certiciate_content"})
    @JsonProperty(value="certificate")
    private String certificate;
    @JsonProperty(value="socket_timeout")
    private Duration socketTimeout;
    @JsonProperty(value="connection_timeout")
    private Duration connectTimeout;
    @JsonProperty(value="insecure")
    private boolean insecure = false;

    public Path getCertPath() {
        return this.certPath;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    @AssertTrue(message="cert and certificate both are configured. Please use only one configuration.")
    @AssertTrue(message="cert and certificate both are configured. Please use only one configuration.") boolean certificateFileAndContentAreMutuallyExclusive() {
        if (this.certPath == null && this.certificate == null) {
            return true;
        }
        return this.certPath != null ^ this.certificate != null;
    }

    @AssertTrue(message="certificate must be either valid PEM file path or public key content.")
    @AssertTrue(message="certificate must be either valid PEM file path or public key content.") boolean isCertificateValid() {
        if (Objects.isNull(this.certificate) || PemObjectValidator.isPemObject((String)this.certificate)) {
            return true;
        }
        try {
            Paths.get(this.certificate, new String[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

