/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch;

import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.UsesSourceCoordination;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessNetworkPolicyUpdater;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessNetworkPolicyUpdaterFactory;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessOptionsFactory;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchIndexProgressState;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchService;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.ServerlessOptions;
import org.opensearch.dataprepper.plugins.source.opensearch.metrics.OpenSearchSourcePluginMetrics;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.OpenSearchClientFactory;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessorStrategy;

@DataPrepperPlugin(name="opensearch", pluginType=Source.class, pluginConfigurationType=OpenSearchSourceConfiguration.class)
public class OpenSearchSource
implements Source<Record<Event>>,
UsesSourceCoordination {
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private final OpenSearchSourceConfiguration openSearchSourceConfiguration;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final PluginMetrics pluginMetrics;
    private final PluginConfigObservable pluginConfigObservable;
    private SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator;
    private OpenSearchService openSearchService;

    @DataPrepperPluginConstructor
    public OpenSearchSource(OpenSearchSourceConfiguration openSearchSourceConfiguration, AwsCredentialsSupplier awsCredentialsSupplier, AcknowledgementSetManager acknowledgementSetManager, PluginMetrics pluginMetrics, PluginConfigObservable pluginConfigObservable) {
        this.openSearchSourceConfiguration = openSearchSourceConfiguration;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.pluginMetrics = pluginMetrics;
        this.pluginConfigObservable = pluginConfigObservable;
        openSearchSourceConfiguration.validateAuthConfigConflictWithDeprecatedUsernameAndPassword();
        openSearchSourceConfiguration.validateAwsConfigWithUsernameAndPassword();
    }

    public void start(Buffer<Record<Event>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        this.maybeUpdateNetworkPolicy();
        this.startProcess(this.openSearchSourceConfiguration, buffer);
    }

    private void startProcess(OpenSearchSourceConfiguration openSearchSourceConfiguration, Buffer<Record<Event>> buffer) {
        OpenSearchClientFactory openSearchClientFactory = OpenSearchClientFactory.create(this.awsCredentialsSupplier);
        OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics = OpenSearchSourcePluginMetrics.create(this.pluginMetrics);
        SearchAccessorStrategy searchAccessorStrategy = SearchAccessorStrategy.create(openSearchSourcePluginMetrics, openSearchSourceConfiguration, openSearchClientFactory, this.pluginConfigObservable);
        SearchAccessor searchAccessor = searchAccessorStrategy.getSearchAccessor();
        this.openSearchService = OpenSearchService.createOpenSearchService(searchAccessor, this.sourceCoordinator, openSearchSourceConfiguration, buffer, this.acknowledgementSetManager, openSearchSourcePluginMetrics);
        this.openSearchService.start();
    }

    public boolean areAcknowledgementsEnabled() {
        return this.openSearchSourceConfiguration.isAcknowledgmentsEnabled();
    }

    public void stop() {
        if (Objects.nonNull(this.openSearchService)) {
            this.openSearchService.stop();
        }
    }

    public <T> void setSourceCoordinator(SourceCoordinator<T> sourceCoordinator) {
        this.sourceCoordinator = sourceCoordinator;
    }

    public Class<?> getPartitionProgressStateClass() {
        return OpenSearchIndexProgressState.class;
    }

    void maybeUpdateNetworkPolicy() {
        Optional<ServerlessOptions> maybeServerlessOptions = ServerlessOptionsFactory.create(this.openSearchSourceConfiguration.getAwsAuthenticationOptions());
        if (maybeServerlessOptions.isPresent()) {
            ServerlessNetworkPolicyUpdater networkPolicyUpdater = ServerlessNetworkPolicyUpdaterFactory.create(this.awsCredentialsSupplier, this.openSearchSourceConfiguration.getAwsAuthenticationOptions());
            networkPolicyUpdater.updateNetworkPolicy(maybeServerlessOptions.get().getNetworkPolicyName(), maybeServerlessOptions.get().getCollectionName(), maybeServerlessOptions.get().getVpceId());
        }
    }
}

