/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch.indices.GetIndexTemplateResponse;
import org.opensearch.client.opensearch.indices.get_index_template.IndexTemplateItem;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ComposableIndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;

class ComposableIndexTemplateStrategy
implements TemplateStrategy {
    private final IndexTemplateAPIWrapper<GetIndexTemplateResponse> indexTemplateAPIWrapper;

    public ComposableIndexTemplateStrategy(IndexTemplateAPIWrapper<GetIndexTemplateResponse> indexTemplateAPIWrapper) {
        this.indexTemplateAPIWrapper = indexTemplateAPIWrapper;
    }

    @Override
    public Optional<Long> getExistingTemplateVersion(String templateName) throws IOException {
        return this.indexTemplateAPIWrapper.getTemplate(templateName).map(getIndexTemplateResponse -> {
            List indexTemplateItems = getIndexTemplateResponse.indexTemplates();
            if (indexTemplateItems.size() == 1) {
                return ((IndexTemplateItem)indexTemplateItems.stream().findFirst().get()).indexTemplate().version();
            }
            throw new RuntimeException(String.format("Found zero or multiple index templates result when querying for %s", templateName));
        });
    }

    @Override
    public IndexTemplate createIndexTemplate(Map<String, Object> templateMap) {
        return new ComposableIndexTemplate(templateMap);
    }

    @Override
    public void createTemplate(IndexTemplate indexTemplate) throws IOException {
        this.indexTemplateAPIWrapper.putTemplate(indexTemplate);
    }
}

