/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.dlq;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.opensearch.dataprepper.model.event.EventHandle;

public class FailedDlqData {
    private final String index;
    private final String indexId;
    private final int status;
    private final String message;
    private final Object document;
    @JsonIgnore
    private final EventHandle eventHandle;

    private FailedDlqData(String index, String indexId, int status, String message, Object document, EventHandle eventHandle) {
        Objects.requireNonNull(index);
        this.index = index;
        this.indexId = indexId;
        this.status = status;
        Objects.requireNonNull(message);
        this.message = message;
        Objects.requireNonNull(document);
        this.document = document;
        this.eventHandle = eventHandle;
    }

    public String getIndex() {
        return this.index;
    }

    public int getStatus() {
        return this.status;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getDocument() {
        return this.document;
    }

    public EventHandle getEventHandle() {
        return this.eventHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedDlqData that = (FailedDlqData)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.indexId, that.indexId) && Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message) && Objects.equals(this.document, that.document);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexId, this.status, this.message, this.document);
    }

    public String toString() {
        return "FailedDlqData{index='" + this.index + "', indexId='" + this.indexId + "', status='" + this.status + "', message='" + this.message + "', document=" + String.valueOf(this.document) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String index;
        private String indexId;
        private EventHandle eventHandle;
        private int status = 0;
        private String message;
        private Object document;

        public Builder withIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder withIndexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withDocument(Object document) {
            this.document = document;
            return this;
        }

        public Builder withEventHandle(EventHandle eventHandle) {
            this.eventHandle = eventHandle;
            return this;
        }

        public FailedDlqData build() {
            return new FailedDlqData(this.index, this.indexId, this.status, this.message, this.document, this.eventHandle);
        }
    }
}

