/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.plugins.sink.opensearch.DistributionVersion;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.ActionConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.AwsAuthenticationConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.DlqConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.ServerlessOptions;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateType;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.model.QueryForExistingDocumentConfiguration;

public class OpenSearchSinkConfig {
    public static final long DEFAULT_BULK_SIZE = 5L;
    public static final boolean DEFAULT_ESTIMATE_BULK_SIZE_USING_COMPRESSION = false;
    public static final int DEFAULT_MAX_LOCAL_COMPRESSIONS_FOR_ESTIMATION = 2;
    public static final long DEFAULT_FLUSH_TIMEOUT = 60000L;
    public static final String DEFAULT_AWS_REGION = "us-east-1";
    @JsonProperty(value="hosts")
    private List<String> hosts;
    @JsonProperty(value="username")
    private String username = null;
    @JsonProperty(value="api_token")
    private String apitoken = null;
    @JsonProperty(value="authentication")
    private AuthConfig authConfig;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="socket_timeout")
    private Integer socketTimeout = null;
    @JsonProperty(value="connect_timeout")
    private Integer connectTimeout = null;
    @JsonProperty(value="aws")
    @Valid
    private AwsAuthenticationConfiguration awsAuthenticationOptions;
    @JsonProperty(value="cert")
    private String certPath = null;
    @JsonProperty(value="insecure")
    private boolean insecure = false;
    @JsonProperty(value="proxy")
    private String proxy = null;
    @JsonProperty(value="distribution_version")
    private String distributionVersion = DistributionVersion.DEFAULT.getVersion();
    @JsonProperty(value="enable_request_compression")
    private Boolean enableRequestCompression = null;
    @JsonProperty(value="index")
    private String indexAlias = null;
    @JsonProperty(value="index_type")
    private String indexType = null;
    @JsonProperty(value="template_type")
    private String templateType = TemplateType.V1.getTypeName();
    @JsonProperty(value="template_file")
    private String templateFile = null;
    @JsonProperty(value="template_content")
    private String templateContent = null;
    @JsonProperty(value="number_of_shards")
    private Integer numShards = 0;
    @JsonProperty(value="number_of_replicas")
    private Integer numReplicas = 0;
    @JsonProperty(value="bulk_size")
    private Long bulkSize = 5L;
    @JsonProperty(value="estimate_bulk_size_using_compression")
    private boolean estimateBulkSizeUsingCompression = false;
    @JsonProperty(value="max_local_compressions_for_estimation")
    private Integer maxLocalCompressionsForEstimation = 2;
    @JsonProperty(value="flush_timeout")
    private Long flushTimeout = 60000L;
    @JsonProperty(value="document_version_type")
    private String versionType = null;
    @JsonProperty(value="document_version")
    private String versionExpression = null;
    @JsonProperty(value="normalize_index")
    private boolean normalizeIndex = false;
    @JsonProperty(value="document_id")
    private String documentId = null;
    @JsonProperty(value="routing")
    private String routing = null;
    @JsonProperty(value="ism_policy_file")
    private String ismPolicyFile = null;
    @JsonProperty(value="action")
    private String action = OpenSearchBulkActions.INDEX.toString();
    @Valid
    @JsonProperty(value="actions")
    private List<ActionConfiguration> actions = null;
    @JsonProperty(value="document_root_key")
    private String documentRootKey = null;
    @JsonProperty(value="dlq_file")
    private String dlqFile = null;
    @JsonProperty(value="max_retries")
    private Integer maxRetries = null;
    @JsonProperty(value="dlq")
    private DlqConfiguration dlq;
    @JsonProperty(value="query_lookup")
    private QueryForExistingDocumentConfiguration queryExistingConfiguration;
    @Deprecated
    @JsonProperty(value="aws_sigv4")
    private boolean awsSigv4 = false;
    @Deprecated
    @JsonProperty(value="aws_region")
    @Size(min=1, message="Region cannot be empty string")
    private @Size(min=1, message="Region cannot be empty string") String awsRegion = "us-east-1";
    @Deprecated
    @JsonProperty(value="aws_sts_role_arn")
    @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters")
    private @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters") String awsStsRoleArn = null;
    @Deprecated
    @JsonProperty(value="aws_sts_external_id")
    @Size(min=2, max=1224, message="awsStsExternalId length should be between 2 and 1224 characters")
    private @Size(min=2, max=1224, message="awsStsExternalId length should be between 2 and 1224 characters") String awsStsExternalId = null;
    @Deprecated
    @JsonProperty(value="aws_sts_header_overrides")
    @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override")
    private @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override") Map<String, String> awsStsHeaderOverrides;
    @Deprecated
    @JsonProperty(value="serverless")
    private boolean serverless = false;
    @Deprecated
    @JsonProperty(value="serverless_options")
    private ServerlessOptions serverlessOptions = null;
    @Deprecated
    @JsonProperty(value="document_id_field")
    private String documentIdField = null;
    @Deprecated
    @JsonProperty(value="routing_field")
    private String routingField = null;

    @AssertTrue(message="username and password should not be set when authentication is configured.")
    public @AssertTrue(message="username and password should not be set when authentication is configured.") boolean isAuthConfigValid() {
        return this.authConfig == null || this.username == null && this.password == null;
    }

    public boolean getEnableRequestCompression() {
        DistributionVersion distributionVersion = DistributionVersion.fromTypeName(this.getDistributionVersion());
        return Objects.requireNonNullElse(this.enableRequestCompression, !DistributionVersion.ES6.equals((Object)distributionVersion));
    }

    @AssertTrue(message="dlq_file option cannot be used along with dlq option")
    public @AssertTrue(message="dlq_file option cannot be used along with dlq option") boolean isDlqValid() {
        return this.dlq == null || this.dlqFile == null;
    }

    @Deprecated
    @AssertTrue(message="aws_sigv4 option cannot be used along with aws option. It is preferred to only use aws option as aws_sigv4 is deprecated.")
    public @AssertTrue(message="aws_sigv4 option cannot be used along with aws option. It is preferred to only use aws option as aws_sigv4 is deprecated.") boolean isNotAwsSigv4AndAwsOption() {
        return this.awsAuthenticationOptions == null || !this.awsSigv4;
    }

    @Deprecated
    @AssertTrue(message="aws_sts_role_arn cannot be used along with aws option. It is preferred to only use aws option as aws_sts_role_arn is deprecated.")
    public @AssertTrue(message="aws_sts_role_arn cannot be used along with aws option. It is preferred to only use aws option as aws_sts_role_arn is deprecated.") boolean isNotAwsStsRoleArnAndAws() {
        return this.awsAuthenticationOptions == null || this.awsStsRoleArn == null;
    }

    @Deprecated
    @AssertTrue(message="aws_sts_external_id cannot be used along with aws option. It is preferred to only use aws option as aws_sts_external_id is deprecated.")
    public @AssertTrue(message="aws_sts_external_id cannot be used along with aws option. It is preferred to only use aws option as aws_sts_external_id is deprecated.") boolean isNotAwsStsExternalIdAndAws() {
        return this.awsAuthenticationOptions == null || this.awsStsExternalId == null;
    }

    @Deprecated
    @AssertTrue(message="aws_sts_header_overrides cannot be used along with aws option. It is preferred to only use aws option as aws_sts_header_overrides is deprecated.")
    public @AssertTrue(message="aws_sts_header_overrides cannot be used along with aws option. It is preferred to only use aws option as aws_sts_header_overrides is deprecated.") boolean isNotAwsStsHeaderOverridesAndAws() {
        return this.awsAuthenticationOptions == null || this.awsStsHeaderOverrides == null;
    }

    @Deprecated
    @AssertTrue(message="serverless cannot be used along with aws option. It is preferred to only use aws option as serverless is deprecated.")
    public @AssertTrue(message="serverless cannot be used along with aws option. It is preferred to only use aws option as serverless is deprecated.") boolean isNotServerlessAndAws() {
        return this.awsAuthenticationOptions == null || !this.serverless;
    }

    @Deprecated
    @AssertTrue(message="serverless_options cannot be used along with aws option.  It is preferred to only use aws option as serverless_options is deprecated.")
    public @AssertTrue(message="serverless_options cannot be used along with aws option.  It is preferred to only use aws option as serverless_options is deprecated.") boolean isNotServerlessOptionsAndAws() {
        return this.awsAuthenticationOptions == null || this.serverlessOptions == null;
    }

    @Deprecated
    @AssertTrue(message="Both document_id_field and document_id cannot be used at the same time. It is preferred to only use document_id as document_id_field is deprecated.")
    public @AssertTrue(message="Both document_id_field and document_id cannot be used at the same time. It is preferred to only use document_id as document_id_field is deprecated.") boolean isNotDocumentIdFieldAndDocumentId() {
        return this.documentId == null || this.documentIdField == null;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getApitoken() {
        return this.apitoken;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public AwsAuthenticationConfiguration getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getDistributionVersion() {
        return this.distributionVersion;
    }

    public String getIndexAlias() {
        return this.indexAlias;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public String getTemplateContent() {
        return this.templateContent;
    }

    public Integer getNumShards() {
        return this.numShards;
    }

    public Integer getNumReplicas() {
        return this.numReplicas;
    }

    public Long getBulkSize() {
        return this.bulkSize;
    }

    public boolean isEstimateBulkSizeUsingCompression() {
        return this.estimateBulkSizeUsingCompression;
    }

    public Integer getMaxLocalCompressionsForEstimation() {
        return this.maxLocalCompressionsForEstimation;
    }

    public Long getFlushTimeout() {
        return this.flushTimeout;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public String getVersionExpression() {
        return this.versionExpression;
    }

    public boolean isNormalizeIndex() {
        return this.normalizeIndex;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getRouting() {
        return this.routing;
    }

    public String getIsmPolicyFile() {
        return this.ismPolicyFile;
    }

    public String getAction() {
        return this.action;
    }

    public List<ActionConfiguration> getActions() {
        return this.actions;
    }

    public String getDocumentRootKey() {
        return this.documentRootKey;
    }

    public String getDlqFile() {
        return this.dlqFile;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public DlqConfiguration getDlq() {
        return this.dlq;
    }

    public QueryForExistingDocumentConfiguration getQueryExistingConfiguration() {
        return this.queryExistingConfiguration;
    }

    @Deprecated
    public boolean isAwsSigv4() {
        return this.awsSigv4;
    }

    @Deprecated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    @Deprecated
    public String getAwsStsRoleArn() {
        return this.awsStsRoleArn;
    }

    @Deprecated
    public String getAwsStsExternalId() {
        return this.awsStsExternalId;
    }

    @Deprecated
    public Map<String, String> getAwsStsHeaderOverrides() {
        return this.awsStsHeaderOverrides;
    }

    @Deprecated
    public boolean isServerless() {
        return this.serverless;
    }

    @Deprecated
    public ServerlessOptions getServerlessOptions() {
        return this.serverlessOptions;
    }

    @Deprecated
    public String getDocumentIdField() {
        return this.documentIdField;
    }

    @Deprecated
    public String getRoutingField() {
        return this.routingField;
    }
}

