/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkOperationWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJson;
import org.opensearch.dataprepper.plugins.sink.opensearch.dlq.FailedDlqData;

public class BulkOperationWriter {
    private static final int MAX_SOURCE_LENGTH_IN_TOSTRING = 2048;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String bulkOperationToString(BulkOperationWrapper bulkOperation) {
        String index = bulkOperation.getIndex();
        String source = BulkOperationWriter.extractDocumentSource(bulkOperation);
        String id = bulkOperation.getId();
        Object sSource = "_na_";
        try {
            sSource = source.length() > 2048 ? "n/a, actual length: [" + new ByteSizeValue((long)source.length()).toString() + "], max length: " + new ByteSizeValue(2048L).toString() : source;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[" + index + "][" + id + "], source[" + (String)sSource + "]}";
    }

    public static String dlqObjectToString(DlqObject dlqObject) {
        FailedDlqData failedData = (FailedDlqData)dlqObject.getFailedData();
        String index = failedData.getIndex();
        String id = failedData.getIndexId();
        String source = BulkOperationWriter.extractDocumentSource(failedData);
        return "index {[" + index + "][" + id + "], source[" + source + "]}";
    }

    private static String extractDocumentSource(FailedDlqData failedData) {
        try {
            return OBJECT_MAPPER.writeValueAsString(failedData.getDocument());
        }
        catch (JsonProcessingException e) {
            return "n/a, unable to extract document";
        }
    }

    private static String extractDocumentSource(BulkOperationWrapper bulkOperation) {
        SerializedJson document = (SerializedJson)bulkOperation.getDocument();
        return new String(document.getSerializedJson());
    }
}

