/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.CreateOperation;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.common.unit.ByteSizeUnit;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.common.concurrent.BackgroundThreadFactory;
import org.opensearch.dataprepper.expression.ExpressionEvaluationException;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.exceptions.EventKeyNotFoundException;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessNetworkPolicyUpdater;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessNetworkPolicyUpdaterFactory;
import org.opensearch.dataprepper.plugins.common.opensearch.ServerlessOptionsFactory;
import org.opensearch.dataprepper.plugins.dlq.DlqProvider;
import org.opensearch.dataprepper.plugins.dlq.DlqWriter;
import org.opensearch.dataprepper.plugins.dlq.s3.S3DlqProvider;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkOperationWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.BulkRetryStrategy;
import org.opensearch.dataprepper.plugins.sink.opensearch.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.OpenSearchClientRefresher;
import org.opensearch.dataprepper.plugins.sink.opensearch.OpenSearchSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.AccumulatingBulkRequest;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.BulkApiWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.BulkApiWrapperFactory;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.BulkOperationWriter;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.JavaClientAccumulatingCompressedBulkRequest;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.JavaClientAccumulatingUncompressedBulkRequest;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJson;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.ActionConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.DlqConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.OpenSearchSinkConfig;
import org.opensearch.dataprepper.plugins.sink.opensearch.dlq.FailedBulkOperation;
import org.opensearch.dataprepper.plugins.sink.opensearch.dlq.FailedBulkOperationConverter;
import org.opensearch.dataprepper.plugins.sink.opensearch.dlq.FailedDlqData;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ClusterSettingsParser;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.DocumentBuilder;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ExistingDocumentQueryManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexManagerFactory;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapperFactory;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexType;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;
import org.opensearch.dataprepper.plugins.source.opensearch.configuration.ServerlessOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="opensearch", pluginType=Sink.class, pluginConfigurationType=OpenSearchSinkConfig.class)
public class OpenSearchSink
extends AbstractSink<Record<Event>> {
    public static final String BULKREQUEST_LATENCY = "bulkRequestLatency";
    public static final String BULKREQUEST_ERRORS = "bulkRequestErrors";
    public static final String INVALID_ACTION_ERRORS = "invalidActionErrors";
    public static final String BULKREQUEST_SIZE_BYTES = "bulkRequestSizeBytes";
    public static final String DYNAMIC_INDEX_DROPPED_EVENTS = "dynamicIndexDroppedEvents";
    public static final String INVALID_VERSION_EXPRESSION_DROPPED_EVENTS = "dynamicDocumentVersionDroppedEvents";
    private static final String PLUGIN_NAME = "opensearch";
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchSink.class);
    private static final int INITIALIZE_RETRY_WAIT_TIME_MS = 5000;
    private final AwsCredentialsSupplier awsCredentialsSupplier;
    private DlqWriter dlqWriter;
    private BufferedWriter dlqFileWriter;
    private final OpenSearchSinkConfiguration openSearchSinkConfig;
    private final IndexManagerFactory indexManagerFactory;
    private RestHighLevelClient restHighLevelClient;
    private IndexManager indexManager;
    private Supplier<AccumulatingBulkRequest> bulkRequestSupplier;
    private BulkRetryStrategy bulkRetryStrategy;
    private BulkApiWrapper bulkApiWrapper;
    private final long bulkSize;
    private final long flushTimeout;
    private final IndexType indexType;
    private final String documentIdField;
    private final String documentId;
    private final String routingField;
    private final String routing;
    private final String pipeline;
    private final String action;
    private final List<ActionConfiguration> actions;
    private final String documentRootKey;
    private String configuredIndexAlias;
    private final ReentrantLock lock;
    private final VersionType versionType;
    private final String versionExpression;
    private final Timer bulkRequestTimer;
    private final Counter bulkRequestErrorsCounter;
    private final Counter invalidActionErrorsCounter;
    private final Counter dynamicIndexDroppedEvents;
    private final DistributionSummary bulkRequestSizeBytesSummary;
    private final Counter dynamicDocumentVersionDroppedEvents;
    private OpenSearchClient openSearchClient;
    private OpenSearchClientRefresher openSearchClientRefresher;
    private ObjectMapper objectMapper;
    private volatile boolean initialized;
    private final SinkContext sinkContext;
    private final ExpressionEvaluator expressionEvaluator;
    private FailedBulkOperationConverter failedBulkOperationConverter;
    private DlqProvider dlqProvider;
    private final ConcurrentHashMap<Long, AccumulatingBulkRequest<BulkOperationWrapper, BulkRequest>> bulkRequestMap;
    private final ConcurrentHashMap<Long, Long> lastFlushTimeMap;
    private final PluginConfigObservable pluginConfigObservable;
    private ExistingDocumentQueryManager existingDocumentQueryManager;
    private final ExecutorService queryExecutorService;
    private final int processWorkerThreads;

    @DataPrepperPluginConstructor
    public OpenSearchSink(PluginSetting pluginSetting, SinkContext sinkContext, ExpressionEvaluator expressionEvaluator, AwsCredentialsSupplier awsCredentialsSupplier, PipelineDescription pipelineDescription, PluginConfigObservable pluginConfigObservable, OpenSearchSinkConfig openSearchSinkConfiguration) {
        super(pluginSetting, Integer.MAX_VALUE, 5000);
        this.processWorkerThreads = pipelineDescription.getNumberOfProcessWorkers();
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.sinkContext = sinkContext != null ? sinkContext : new SinkContext(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        this.expressionEvaluator = expressionEvaluator;
        this.pipeline = pipelineDescription.getPipelineName();
        this.bulkRequestTimer = this.pluginMetrics.timer(BULKREQUEST_LATENCY);
        this.bulkRequestErrorsCounter = this.pluginMetrics.counter(BULKREQUEST_ERRORS);
        this.invalidActionErrorsCounter = this.pluginMetrics.counter(INVALID_ACTION_ERRORS);
        this.dynamicIndexDroppedEvents = this.pluginMetrics.counter(DYNAMIC_INDEX_DROPPED_EVENTS);
        this.bulkRequestSizeBytesSummary = this.pluginMetrics.summary(BULKREQUEST_SIZE_BYTES);
        this.dynamicDocumentVersionDroppedEvents = this.pluginMetrics.counter(INVALID_VERSION_EXPRESSION_DROPPED_EVENTS);
        this.openSearchSinkConfig = OpenSearchSinkConfiguration.readOSConfig(openSearchSinkConfiguration, expressionEvaluator);
        this.bulkSize = ByteSizeUnit.MB.toBytes(this.openSearchSinkConfig.getIndexConfiguration().getBulkSize());
        this.flushTimeout = this.openSearchSinkConfig.getIndexConfiguration().getFlushTimeout();
        this.indexType = this.openSearchSinkConfig.getIndexConfiguration().getIndexType();
        this.documentIdField = this.openSearchSinkConfig.getIndexConfiguration().getDocumentIdField();
        this.documentId = this.openSearchSinkConfig.getIndexConfiguration().getDocumentId();
        this.routingField = this.openSearchSinkConfig.getIndexConfiguration().getRoutingField();
        this.routing = this.openSearchSinkConfig.getIndexConfiguration().getRouting();
        this.action = this.openSearchSinkConfig.getIndexConfiguration().getAction();
        this.actions = this.openSearchSinkConfig.getIndexConfiguration().getActions();
        this.documentRootKey = this.openSearchSinkConfig.getIndexConfiguration().getDocumentRootKey();
        this.versionType = this.openSearchSinkConfig.getIndexConfiguration().getVersionType();
        this.versionExpression = this.openSearchSinkConfig.getIndexConfiguration().getVersionExpression();
        this.indexManagerFactory = new IndexManagerFactory(new ClusterSettingsParser());
        this.failedBulkOperationConverter = new FailedBulkOperationConverter(this.pipeline, PLUGIN_NAME);
        this.initialized = false;
        this.lock = new ReentrantLock(true);
        this.bulkRequestMap = new ConcurrentHashMap();
        this.lastFlushTimeMap = new ConcurrentHashMap();
        this.pluginConfigObservable = pluginConfigObservable;
        this.objectMapper = new ObjectMapper();
        this.queryExecutorService = this.openSearchSinkConfig.getIndexConfiguration().getQueryTerm() != null ? Executors.newSingleThreadExecutor((ThreadFactory)BackgroundThreadFactory.defaultExecutorThreadFactory((String)"existing-document-query-manager")) : null;
        Optional<DlqConfiguration> dlqConfig = this.openSearchSinkConfig.getRetryConfiguration().getDlq();
        if (dlqConfig.isPresent()) {
            this.dlqProvider = new S3DlqProvider(dlqConfig.get().getS3DlqWriterConfig());
        }
    }

    public void doInitialize() {
        try {
            this.doInitializeInternal();
        }
        catch (IOException e) {
            LOG.warn("Failed to initialize OpenSearch sink, retrying: {} ", (Object)e.getMessage());
            this.shutdown();
        }
        catch (InvalidPluginConfigurationException e) {
            LOG.error("Failed to initialize OpenSearch sink due to a configuration error.", (Throwable)e);
            this.shutdown();
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Failed to initialize OpenSearch sink due to a configuration error.", (Throwable)e);
            this.shutdown();
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize OpenSearch sink with a retryable exception. ", (Throwable)e);
            this.shutdown();
        }
    }

    private void doInitializeInternal() throws IOException {
        LOG.info("Initializing OpenSearch sink");
        ConnectionConfiguration connectionConfiguration = this.openSearchSinkConfig.getConnectionConfiguration();
        this.restHighLevelClient = connectionConfiguration.createClient(this.awsCredentialsSupplier);
        this.openSearchClient = connectionConfiguration.createOpenSearchClient(this.restHighLevelClient, this.awsCredentialsSupplier);
        Function<ConnectionConfiguration, OpenSearchClient> clientFunction = connectionConfiguration1 -> {
            RestHighLevelClient restHighLevelClient1 = connectionConfiguration1.createClient(this.awsCredentialsSupplier);
            return connectionConfiguration1.createOpenSearchClient(restHighLevelClient1, this.awsCredentialsSupplier).withTransportOptions((TransportOptions)TransportOptions.builder().setParameter("filter_path", "errors,took,items.*.error,items.*.status,items.*._index,items.*._id").build());
        };
        this.openSearchClientRefresher = new OpenSearchClientRefresher(this.pluginMetrics, connectionConfiguration, clientFunction);
        if (this.queryExecutorService != null) {
            this.existingDocumentQueryManager = new ExistingDocumentQueryManager(this.openSearchSinkConfig.getIndexConfiguration(), this.pluginMetrics, this.openSearchClient);
            this.queryExecutorService.submit(this.existingDocumentQueryManager);
        }
        this.pluginConfigObservable.addPluginConfigObserver(newOpenSearchSinkConfig -> this.openSearchClientRefresher.update((OpenSearchSinkConfig)newOpenSearchSinkConfig));
        this.configuredIndexAlias = this.openSearchSinkConfig.getIndexConfiguration().getIndexAlias();
        IndexTemplateAPIWrapper indexTemplateAPIWrapper = IndexTemplateAPIWrapperFactory.getWrapper(this.openSearchSinkConfig.getIndexConfiguration(), this.openSearchClient);
        TemplateStrategy templateStrategy = this.openSearchSinkConfig.getIndexConfiguration().getTemplateType().createTemplateStrategy(indexTemplateAPIWrapper);
        this.indexManager = this.indexManagerFactory.getIndexManager(this.indexType, this.openSearchClient, this.restHighLevelClient, this.openSearchSinkConfig, templateStrategy, this.configuredIndexAlias);
        String dlqFile = this.openSearchSinkConfig.getRetryConfiguration().getDlqFile();
        if (dlqFile != null) {
            this.dlqFileWriter = Files.newBufferedWriter(Paths.get(dlqFile, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        } else if (this.dlqProvider != null) {
            Optional potentialDlq = this.dlqProvider.getDlqWriter(new StringJoiner(".").add(this.pipeline).add(PLUGIN_NAME).toString());
            this.dlqWriter = potentialDlq.isPresent() ? (DlqWriter)potentialDlq.get() : null;
        }
        this.maybeUpdateServerlessNetworkPolicy();
        this.indexManager.setupIndex();
        Boolean requireAlias = this.indexManager.isIndexAlias(this.configuredIndexAlias);
        boolean isEstimateBulkSizeUsingCompression = this.openSearchSinkConfig.getIndexConfiguration().isEstimateBulkSizeUsingCompression();
        boolean isRequestCompressionEnabled = this.openSearchSinkConfig.getConnectionConfiguration().isRequestCompressionEnabled();
        if (isEstimateBulkSizeUsingCompression && isRequestCompressionEnabled) {
            int maxLocalCompressionsForEstimation = this.openSearchSinkConfig.getIndexConfiguration().getMaxLocalCompressionsForEstimation();
            this.bulkRequestSupplier = () -> new JavaClientAccumulatingCompressedBulkRequest(new BulkRequest.Builder().requireAlias(requireAlias), this.bulkSize, maxLocalCompressionsForEstimation);
        } else if (isEstimateBulkSizeUsingCompression) {
            LOG.warn("Estimate bulk request size using compression was enabled but request compression is disabled. Estimating bulk request size without compression.");
            this.bulkRequestSupplier = () -> new JavaClientAccumulatingUncompressedBulkRequest(new BulkRequest.Builder().requireAlias(requireAlias));
        } else {
            this.bulkRequestSupplier = () -> new JavaClientAccumulatingUncompressedBulkRequest(new BulkRequest.Builder().requireAlias(requireAlias));
        }
        int maxRetries = this.openSearchSinkConfig.getRetryConfiguration().getMaxRetries();
        this.bulkApiWrapper = BulkApiWrapperFactory.getWrapper(this.openSearchSinkConfig.getIndexConfiguration(), () -> this.openSearchClientRefresher.get());
        this.bulkRetryStrategy = new BulkRetryStrategy(bulkRequest -> this.bulkApiWrapper.bulk((BulkRequest)bulkRequest.getRequest()), this::logFailureForBulkRequests, this.pluginMetrics, maxRetries, this.bulkRequestSupplier, this.pipeline, PLUGIN_NAME, this.openSearchSinkConfig.getIndexConfiguration().getQueryOnBulkFailures() ? this.existingDocumentQueryManager : null);
        this.initialized = true;
        LOG.info("Initialized OpenSearch sink");
    }

    double getInvalidActionErrorsCount() {
        return this.invalidActionErrorsCounter.count();
    }

    public boolean isReady() {
        return this.initialized;
    }

    private BulkOperation getBulkOperationForAction(String action, SerializedJson document, Long version, String indexName, JsonNode jsonNode) {
        Optional<String> docId = document.getDocumentId();
        Optional<String> routing = document.getRoutingField();
        Optional<String> pipeline = document.getPipelineField();
        if (StringUtils.equals((CharSequence)action, (CharSequence)OpenSearchBulkActions.CREATE.toString())) {
            CreateOperation.Builder createOperationBuilder = ((CreateOperation.Builder)new CreateOperation.Builder().index(indexName)).document((Object)document);
            docId.ifPresent(x$0 -> {
                CreateOperation.Builder cfr_ignored_0 = (CreateOperation.Builder)createOperationBuilder.id(x$0);
            });
            routing.ifPresent(x$0 -> {
                CreateOperation.Builder cfr_ignored_0 = (CreateOperation.Builder)createOperationBuilder.routing(x$0);
            });
            pipeline.ifPresent(x$0 -> {
                CreateOperation.Builder cfr_ignored_0 = (CreateOperation.Builder)createOperationBuilder.pipeline(x$0);
            });
            BulkOperation bulkOperation = (BulkOperation)new BulkOperation.Builder().create(createOperationBuilder.build()).build();
            return bulkOperation;
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)OpenSearchBulkActions.UPDATE.toString()) || StringUtils.equals((CharSequence)action, (CharSequence)OpenSearchBulkActions.UPSERT.toString())) {
            JsonNode filteredJsonNode = jsonNode;
            try {
                if (this.isUsingDocumentFilters()) {
                    filteredJsonNode = this.objectMapper.reader().readTree(document.getSerializedJson());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("An exception occurred while deserializing a document for the %s action: %s", action, e.getMessage()));
            }
            UpdateOperation.Builder updateOperationBuilder = StringUtils.equals((CharSequence)action.toLowerCase(), (CharSequence)OpenSearchBulkActions.UPSERT.toString()) ? (UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(indexName)).document((Object)filteredJsonNode).upsert((Object)filteredJsonNode).versionType(this.versionType)).version(version) : (UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(indexName)).document((Object)filteredJsonNode).versionType(this.versionType)).version(version);
            docId.ifPresent(x$0 -> {
                UpdateOperation.Builder cfr_ignored_0 = (UpdateOperation.Builder)updateOperationBuilder.id(x$0);
            });
            routing.ifPresent(x$0 -> {
                UpdateOperation.Builder cfr_ignored_0 = (UpdateOperation.Builder)updateOperationBuilder.routing(x$0);
            });
            BulkOperation bulkOperation = (BulkOperation)new BulkOperation.Builder().update(updateOperationBuilder.build()).build();
            return bulkOperation;
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)OpenSearchBulkActions.DELETE.toString())) {
            DeleteOperation.Builder deleteOperationBuilder = (DeleteOperation.Builder)new DeleteOperation.Builder().index(indexName);
            docId.ifPresent(x$0 -> {
                DeleteOperation.Builder cfr_ignored_0 = (DeleteOperation.Builder)deleteOperationBuilder.id(x$0);
            });
            routing.ifPresent(x$0 -> {
                DeleteOperation.Builder cfr_ignored_0 = (DeleteOperation.Builder)deleteOperationBuilder.routing(x$0);
            });
            BulkOperation bulkOperation = (BulkOperation)new BulkOperation.Builder().delete(((DeleteOperation.Builder)((DeleteOperation.Builder)deleteOperationBuilder.versionType(this.versionType)).version(version)).build()).build();
            return bulkOperation;
        }
        IndexOperation.Builder indexOperationBuilder = (IndexOperation.Builder)((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().index(indexName)).document((Object)document).version(version)).versionType(this.versionType);
        docId.ifPresent(x$0 -> {
            IndexOperation.Builder cfr_ignored_0 = (IndexOperation.Builder)indexOperationBuilder.id(x$0);
        });
        routing.ifPresent(x$0 -> {
            IndexOperation.Builder cfr_ignored_0 = (IndexOperation.Builder)indexOperationBuilder.routing(x$0);
        });
        pipeline.ifPresent(x$0 -> {
            IndexOperation.Builder cfr_ignored_0 = (IndexOperation.Builder)indexOperationBuilder.pipeline(x$0);
        });
        BulkOperation bulkOperation = (BulkOperation)new BulkOperation.Builder().index(indexOperationBuilder.build()).build();
        return bulkOperation;
    }

    public void doOutput(Collection<Record<Event>> records) {
        long threadId = Thread.currentThread().getId();
        if (!this.bulkRequestMap.containsKey(threadId)) {
            this.bulkRequestMap.put(threadId, this.bulkRequestSupplier.get());
        }
        if (!this.lastFlushTimeMap.containsKey(threadId)) {
            this.lastFlushTimeMap.put(threadId, System.currentTimeMillis());
        }
        AccumulatingBulkRequest<BulkOperationWrapper, BulkRequest> bulkRequest = this.bulkRequestMap.get(threadId);
        long lastFlushTime = this.lastFlushTimeMap.get(threadId);
        Set<Object> documentsReadyForIndexing = new HashSet();
        if (this.openSearchSinkConfig.getIndexConfiguration().getQueryTerm() != null) {
            documentsReadyForIndexing = this.existingDocumentQueryManager.getAndClearBulkOperationsReadyToIndex();
        }
        if (!documentsReadyForIndexing.isEmpty()) {
            LOG.info("Found {} documents ready for indexing from query manager", (Object)documentsReadyForIndexing.size());
        }
        for (BulkOperationWrapper bulkOperationWrapper : documentsReadyForIndexing) {
            bulkRequest = this.flushBatch(bulkRequest, bulkOperationWrapper, lastFlushTime);
            bulkRequest.addOperation(bulkOperationWrapper);
        }
        for (Record record : records) {
            BulkOperation bulkOperation;
            Event event = (Event)record.getData();
            SerializedJson document = this.getDocument(event);
            String indexName = this.configuredIndexAlias;
            try {
                indexName = this.indexManager.getIndexName(event.formatString(indexName, this.expressionEvaluator));
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "There was an exception when constructing the index name. Check the dlq if configured to see details about the affected Event: {}", (Object)e.getMessage());
                this.dynamicIndexDroppedEvents.increment();
                this.logFailureForDlqObjects(List.of(this.createDlqObjectFromEvent(event, indexName, e.getMessage())), e);
                continue;
            }
            Long version = null;
            String versionExpressionEvaluationResult = null;
            if (this.versionExpression != null) {
                Object errorMessage;
                try {
                    versionExpressionEvaluationResult = event.formatString(this.versionExpression, this.expressionEvaluator);
                    version = Long.valueOf(event.formatString(this.versionExpression, this.expressionEvaluator));
                }
                catch (NumberFormatException e) {
                    errorMessage = String.format("Unable to convert the result of evaluating document_version '%s' to Long for an Event. The evaluation result '%s' must be a valid Long type", this.versionExpression, versionExpressionEvaluationResult);
                    LOG.error((String)errorMessage);
                    this.logFailureForDlqObjects(List.of(this.createDlqObjectFromEvent(event, indexName, (String)errorMessage)), e);
                    this.dynamicDocumentVersionDroppedEvents.increment();
                }
                catch (RuntimeException e) {
                    errorMessage = String.format("There was an exception when evaluating the document_version '%s': %s", this.versionExpression, e.getMessage());
                    LOG.error((String)errorMessage + " Check the dlq if configured to see more details about the affected Event");
                    this.logFailureForDlqObjects(List.of(this.createDlqObjectFromEvent(event, indexName, (String)errorMessage)), e);
                    this.dynamicDocumentVersionDroppedEvents.increment();
                }
            }
            String eventAction = this.action;
            if (this.actions != null) {
                for (ActionConfiguration actionEntry : this.actions) {
                    String condition = actionEntry.getWhen();
                    eventAction = actionEntry.getType();
                    if (condition == null || !this.expressionEvaluator.evaluateConditional(condition, event).booleanValue()) continue;
                    break;
                }
            }
            if (eventAction.contains("${")) {
                eventAction = event.formatString(eventAction, this.expressionEvaluator);
            }
            if (OpenSearchBulkActions.fromOptionValue((String)eventAction) == null) {
                LOG.error("Unknown action {}, skipping the event", (Object)eventAction);
                this.invalidActionErrorsCounter.increment();
                continue;
            }
            SerializedJson serializedJsonNode = null;
            if (StringUtils.equals((CharSequence)eventAction, (CharSequence)OpenSearchBulkActions.UPDATE.toString()) || StringUtils.equals((CharSequence)eventAction, (CharSequence)OpenSearchBulkActions.UPSERT.toString()) || StringUtils.equals((CharSequence)eventAction, (CharSequence)OpenSearchBulkActions.DELETE.toString())) {
                serializedJsonNode = SerializedJson.fromJsonNode(event.getJsonNode(), document);
            }
            try {
                bulkOperation = this.getBulkOperationForAction(eventAction, document, version, indexName, event.getJsonNode());
            }
            catch (Exception e) {
                LOG.error("An exception occurred while constructing the bulk operation for a document: ", (Throwable)e);
                this.logFailureForDlqObjects(List.of(this.createDlqObjectFromEvent(event, indexName, e.getMessage())), e);
                continue;
            }
            String queryTermKey = this.openSearchSinkConfig.getIndexConfiguration().getQueryTerm();
            String termValue = queryTermKey != null ? (String)event.get(queryTermKey, String.class) : null;
            BulkOperationWrapper bulkOperationWrapper = new BulkOperationWrapper(bulkOperation, event.getEventHandle(), serializedJsonNode, termValue);
            if (this.openSearchSinkConfig.getIndexConfiguration().getQueryWhen() != null && this.expressionEvaluator.evaluateConditional(this.openSearchSinkConfig.getIndexConfiguration().getQueryWhen(), event).booleanValue()) {
                this.existingDocumentQueryManager.addBulkOperation(bulkOperationWrapper);
                continue;
            }
            bulkRequest = this.flushBatch(bulkRequest, bulkOperationWrapper, lastFlushTime);
            bulkRequest.addOperation(bulkOperationWrapper);
        }
        if (System.currentTimeMillis() - lastFlushTime > this.flushTimeout && bulkRequest.getOperationsCount() > 0) {
            this.flushBatch(bulkRequest);
            lastFlushTime = System.currentTimeMillis();
            bulkRequest = this.bulkRequestSupplier.get();
        }
        this.bulkRequestMap.put(threadId, bulkRequest);
        this.lastFlushTimeMap.put(threadId, lastFlushTime);
    }

    SerializedJson getDocument(Event event) {
        String docId = null;
        if (Objects.nonNull(this.documentIdField)) {
            docId = (String)event.get(this.documentIdField, String.class);
        } else if (Objects.nonNull(this.documentId)) {
            try {
                docId = event.formatString(this.documentId, this.expressionEvaluator);
            }
            catch (ExpressionEvaluationException | EventKeyNotFoundException e) {
                LOG.error("Unable to construct document_id with format {}, the document_id will be generated by OpenSearch", (Object)this.documentId, (Object)e);
            }
        }
        String routingValue = null;
        if (this.routingField != null) {
            routingValue = (String)event.get(this.routingField, String.class);
        } else if (this.routing != null) {
            try {
                routingValue = event.formatString(this.routing, this.expressionEvaluator);
            }
            catch (ExpressionEvaluationException | EventKeyNotFoundException e) {
                LOG.error("Unable to construct routing with format {}, the routing will be generated by OpenSearch", (Object)this.routing, (Object)e);
            }
        }
        String document = DocumentBuilder.build(event, this.documentRootKey, this.sinkContext.getTagsTargetKey(), this.sinkContext.getIncludeKeys(), this.sinkContext.getExcludeKeys());
        return SerializedJson.fromStringAndOptionals(document, docId, routingValue, null);
    }

    private void flushBatch(AccumulatingBulkRequest accumulatingBulkRequest) {
        this.bulkRequestTimer.record(() -> {
            try {
                LOG.debug("Sending data to OpenSearch");
                this.bulkRetryStrategy.execute(accumulatingBulkRequest);
                this.bulkRequestSizeBytesSummary.record((double)accumulatingBulkRequest.getEstimatedSizeInBytes());
            }
            catch (InterruptedException e) {
                LOG.error("Unexpected Interrupt:", (Throwable)e);
                this.bulkRequestErrorsCounter.increment();
                Thread.currentThread().interrupt();
            }
        });
    }

    private void logFailureForBulkRequests(List<FailedBulkOperation> failedBulkOperations, Throwable failure) {
        List<DlqObject> dlqObjects = failedBulkOperations.stream().map(this.failedBulkOperationConverter::convertToDlqObject).collect(Collectors.toList());
        this.logFailureForDlqObjects(dlqObjects, failure);
    }

    private void logFailureForDlqObjects(List<DlqObject> dlqObjects, Throwable failure) {
        if (this.dlqFileWriter != null) {
            dlqObjects.forEach(dlqObject -> {
                FailedDlqData failedDlqData = (FailedDlqData)dlqObject.getFailedData();
                String message = failure == null ? failedDlqData.getMessage() : failure.getMessage();
                try {
                    this.dlqFileWriter.write(String.format("{\"Document\": [%s], \"failure\": %s}\n", BulkOperationWriter.dlqObjectToString(dlqObject), message));
                    dlqObject.releaseEventHandle(true);
                }
                catch (IOException e) {
                    LOG.error(DataPrepperMarkers.NOISY, "Failed to write a document to the DLQ", (Throwable)e);
                    dlqObject.releaseEventHandle(false);
                }
            });
        } else if (this.dlqWriter != null) {
            try {
                this.dlqWriter.write(dlqObjects, this.pipeline, PLUGIN_NAME);
                dlqObjects.forEach(dlqObject -> dlqObject.releaseEventHandle(true));
            }
            catch (IOException e) {
                dlqObjects.forEach(dlqObject -> {
                    LOG.error(DataPrepperMarkers.NOISY, "Failed to write a document to the DLQ", (Throwable)e);
                    dlqObject.releaseEventHandle(false);
                });
            }
        } else {
            dlqObjects.forEach(dlqObject -> {
                FailedDlqData failedDlqData = (FailedDlqData)dlqObject.getFailedData();
                String message = failure == null ? failedDlqData.getMessage() : failure.getMessage();
                LOG.warn("Document failed to write to OpenSearch with error code {}. Configure a DLQ to save failed documents. Error: {}", (Object)failedDlqData.getStatus(), (Object)message);
                dlqObject.releaseEventHandle(false);
            });
        }
    }

    private void closeFiles() {
        if (this.restHighLevelClient != null) {
            try {
                this.restHighLevelClient.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (this.dlqWriter != null) {
            try {
                this.dlqWriter.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.dlqFileWriter != null) {
            try {
                this.dlqFileWriter.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        super.shutdown();
        this.closeFiles();
        this.openSearchClient.shutdown();
        if (this.queryExecutorService != null) {
            this.existingDocumentQueryManager.stop();
            this.queryExecutorService.shutdown();
        }
    }

    private void maybeUpdateServerlessNetworkPolicy() {
        Optional<ServerlessOptions> maybeServerlessOptions = ServerlessOptionsFactory.create(this.openSearchSinkConfig.getConnectionConfiguration());
        if (maybeServerlessOptions.isPresent()) {
            ServerlessNetworkPolicyUpdater networkPolicyUpdater = ServerlessNetworkPolicyUpdaterFactory.create(this.awsCredentialsSupplier, this.openSearchSinkConfig.getConnectionConfiguration());
            networkPolicyUpdater.updateNetworkPolicy(maybeServerlessOptions.get().getNetworkPolicyName(), maybeServerlessOptions.get().getCollectionName(), maybeServerlessOptions.get().getVpceId());
        }
    }

    private DlqObject createDlqObjectFromEvent(Event event, String index, String message) {
        return DlqObject.builder().withEventHandle(event.getEventHandle()).withFailedData((Object)FailedDlqData.builder().withDocument(event.toJsonString()).withIndex(index).withMessage(message).build()).withPluginName(PLUGIN_NAME).withPipelineName(this.pipeline).withPluginId(PLUGIN_NAME).build();
    }

    private boolean isUsingDocumentFilters() {
        return this.documentRootKey != null || this.sinkContext.getIncludeKeys() != null && !this.sinkContext.getIncludeKeys().isEmpty() || this.sinkContext.getExcludeKeys() != null && !this.sinkContext.getExcludeKeys().isEmpty() || this.sinkContext.getTagsTargetKey() != null;
    }

    private AccumulatingBulkRequest<BulkOperationWrapper, BulkRequest> flushBatch(AccumulatingBulkRequest<BulkOperationWrapper, BulkRequest> bulkRequest, BulkOperationWrapper bulkOperationWrapper, long lastFlushTime) {
        long estimatedBytesBeforeAdd = bulkRequest.estimateSizeInBytesWithDocument(bulkOperationWrapper);
        if (this.bulkSize >= 0L && estimatedBytesBeforeAdd >= this.bulkSize && bulkRequest.getOperationsCount() > 0) {
            this.flushBatch(bulkRequest);
            lastFlushTime = System.currentTimeMillis();
            return this.bulkRequestSupplier.get();
        }
        return bulkRequest;
    }
}

