/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.aws.api.AwsRequestSigningApache4Interceptor;
import org.opensearch.dataprepper.plugins.sink.opensearch.OpenSearchSink;
import org.opensearch.dataprepper.plugins.sink.opensearch.X509TrustAllManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.PreSerializedJsonpMapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.AuthConfig;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.AwsAuthenticationConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.OpenSearchSinkConfig;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.ServerlessOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;

public class ConnectionConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchSink.class);
    private static final String AWS_IAM_ROLE = "role";
    private static final String AWS_IAM = "iam";
    private static final String AOS_SERVICE_NAME = "es";
    private static final String AOSS_SERVICE_NAME = "aoss";
    public static final String HOSTS = "hosts";
    public static final String AWS_SIGV4 = "aws_sigv4";
    public static final String SERVERLESS = "serverless";
    public static final String REQUEST_COMPRESSION_ENABLED = "enable_request_compression";
    private static final ValueRange VALID_PORT_RANGE = ValueRange.of(0L, 65535L);
    private final List<String> hosts;
    private final String username;
    private final String password;
    private final String apitoken;
    private final Path certPath;
    private final Integer socketTimeout;
    private final Integer connectTimeout;
    private final boolean insecure;
    private final boolean awsSigv4;
    private final String awsRegion;
    private final String awsStsRoleArn;
    private final String awsStsExternalId;
    private final Map<String, String> awsStsHeaderOverrides;
    private final Optional<String> proxy;
    private final boolean serverless;
    private final String serverlessNetworkPolicyName;
    private final String serverlessCollectionName;
    private final String serverlessVpceId;
    private final boolean requestCompressionEnabled;
    private final AuthConfig authConfig;

    List<String> getHosts() {
        return this.hosts;
    }

    String getUsername() {
        return this.username;
    }

    String getApitoken() {
        return this.apitoken;
    }

    String getPassword() {
        return this.password;
    }

    boolean isAwsSigv4() {
        return this.awsSigv4;
    }

    String getAwsRegion() {
        return this.awsRegion;
    }

    String getAwsStsRoleArn() {
        return this.awsStsRoleArn;
    }

    Path getCertPath() {
        return this.certPath;
    }

    Optional<String> getProxy() {
        return this.proxy;
    }

    Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isServerless() {
        return this.serverless;
    }

    public String getServerlessNetworkPolicyName() {
        return this.serverlessNetworkPolicyName;
    }

    public String getServerlessCollectionName() {
        return this.serverlessCollectionName;
    }

    public String getServerlessVpceId() {
        return this.serverlessVpceId;
    }

    boolean isRequestCompressionEnabled() {
        return this.requestCompressionEnabled;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    private ConnectionConfiguration(Builder builder) {
        this.hosts = builder.hosts;
        this.username = builder.username;
        this.password = builder.password;
        this.apitoken = builder.apitoken;
        this.socketTimeout = builder.socketTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.certPath = builder.certPath;
        this.insecure = builder.insecure;
        this.awsSigv4 = builder.awsSigv4;
        this.awsRegion = builder.awsRegion;
        this.awsStsRoleArn = builder.awsStsRoleArn;
        this.awsStsExternalId = builder.awsStsExternalId;
        this.awsStsHeaderOverrides = builder.awsStsHeaderOverrides;
        this.proxy = builder.proxy;
        this.serverless = builder.serverless;
        this.serverlessNetworkPolicyName = builder.serverlessNetworkPolicyName;
        this.serverlessCollectionName = builder.serverlessCollectionName;
        this.serverlessVpceId = builder.serverlessVpceId;
        this.requestCompressionEnabled = builder.requestCompressionEnabled;
        this.authConfig = builder.authConfig;
    }

    public static ConnectionConfiguration readConnectionConfiguration(OpenSearchSinkConfig openSearchSinkConfig) {
        ServerlessOptions serverlessOptions;
        Integer connectTimeout;
        List<String> hosts = openSearchSinkConfig.getHosts();
        Builder builder = new Builder(hosts);
        String username = openSearchSinkConfig.getUsername();
        String password = openSearchSinkConfig.getPassword();
        String apitoken = openSearchSinkConfig.getApitoken();
        AuthConfig authConfig = openSearchSinkConfig.getAuthConfig();
        if (authConfig != null) {
            builder = builder.withAuthConfig(authConfig);
        } else {
            if (username != null) {
                builder = builder.withUsername(username);
            }
            if (password != null) {
                builder = builder.withPassword(password);
            }
            if (apitoken != null) {
                builder = builder.withApitoken(apitoken);
            }
        }
        Integer socketTimeout = openSearchSinkConfig.getSocketTimeout();
        if (socketTimeout != null) {
            builder = builder.withSocketTimeout(socketTimeout);
        }
        if ((connectTimeout = openSearchSinkConfig.getConnectTimeout()) != null) {
            builder = builder.withConnectTimeout(connectTimeout);
        }
        builder.withAwsSigv4(false);
        AwsAuthenticationConfiguration awsAuthenticationConfiguration = openSearchSinkConfig.getAwsAuthenticationOptions();
        boolean awsSigv4 = openSearchSinkConfig.isAwsSigv4();
        if (awsAuthenticationConfiguration != null) {
            builder = builder.withAwsSigv4(true).withAwsRegion(awsAuthenticationConfiguration.getAwsRegion().toString()).withAWSStsRoleArn(awsAuthenticationConfiguration.getAwsStsRoleArn()).withAWSStsExternalId(awsAuthenticationConfiguration.getAwsStsExternalId()).withAwsStsHeaderOverrides(awsAuthenticationConfiguration.getAwsStsHeaderOverrides()).withServerless(awsAuthenticationConfiguration.isServerlessCollection());
            serverlessOptions = awsAuthenticationConfiguration.getServerlessOptions();
            if (serverlessOptions != null) {
                builder = builder.withServerlessNetworkPolicyName(serverlessOptions.getNetworkPolicyName()).withServerlessCollectionName(serverlessOptions.getCollectionName()).withServerlessVpceId(serverlessOptions.getVpceId());
            }
        } else if (awsSigv4) {
            builder = builder.withAwsSigv4(awsSigv4).withAwsRegion(openSearchSinkConfig.getAwsRegion()).withAWSStsRoleArn(openSearchSinkConfig.getAwsStsRoleArn()).withAWSStsExternalId(openSearchSinkConfig.getAwsStsExternalId()).withAwsStsHeaderOverrides(openSearchSinkConfig.getAwsStsHeaderOverrides());
            serverlessOptions = openSearchSinkConfig.getServerlessOptions();
            if (serverlessOptions != null) {
                builder = builder.withServerlessNetworkPolicyName(serverlessOptions.getNetworkPolicyName()).withServerlessCollectionName(serverlessOptions.getCollectionName()).withServerlessVpceId(serverlessOptions.getVpceId());
            }
        } else {
            builder.withServerless(false);
        }
        String certPath = openSearchSinkConfig.getCertPath();
        boolean insecure = openSearchSinkConfig.isInsecure();
        if (insecure) {
            builder.withInsecure(insecure);
        } else if (certPath != null) {
            builder.withCert(certPath);
        }
        String proxy = openSearchSinkConfig.getProxy();
        if (proxy != null) {
            builder = builder.withProxy(proxy);
        }
        boolean requestCompressionEnabled = openSearchSinkConfig.getEnableRequestCompression();
        builder = builder.withRequestCompressionEnabled(requestCompressionEnabled);
        return builder.build();
    }

    public RestHighLevelClient createClient(AwsCredentialsSupplier awsCredentialsSupplier) {
        HttpHost[] httpHosts = new HttpHost[this.hosts.size()];
        int i = 0;
        for (String host : this.hosts) {
            httpHosts[i] = HttpHost.create((String)host);
            ++i;
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        if (this.awsSigv4) {
            this.attachSigV4(restClientBuilder, awsCredentialsSupplier);
        } else {
            this.attachUserCredentials(restClientBuilder);
        }
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
            if (this.connectTimeout != null) {
                requestConfigBuilder.setConnectTimeout(this.connectTimeout.intValue());
            }
            if (this.socketTimeout != null) {
                requestConfigBuilder.setSocketTimeout(this.socketTimeout.intValue());
            }
            return requestConfigBuilder;
        });
        return new RestHighLevelClient(restClientBuilder);
    }

    private void attachSigV4(RestClientBuilder restClientBuilder, AwsCredentialsSupplier awsCredentialsSupplier) {
        LOG.info("{} is set, will sign requests using AWSRequestSigningApacheInterceptor", (Object)AWS_SIGV4);
        Aws4Signer aws4Signer = Aws4Signer.create();
        AwsCredentialsOptions awsCredentialsOptions = this.createAwsCredentialsOptions();
        AwsCredentialsProvider credentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        AwsRequestSigningApache4Interceptor httpRequestInterceptor = new AwsRequestSigningApache4Interceptor(AOS_SERVICE_NAME, (Signer)aws4Signer, credentialsProvider, this.awsRegion);
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> this.lambda$attachSigV4$1((HttpRequestInterceptor)httpRequestInterceptor, arg_0));
    }

    public AwsCredentialsOptions createAwsCredentialsOptions() {
        AwsCredentialsOptions awsCredentialsOptions = AwsCredentialsOptions.builder().withStsRoleArn(this.awsStsRoleArn).withStsExternalId(this.awsStsExternalId).withRegion(this.awsRegion).withStsHeaderOverrides(this.awsStsHeaderOverrides).build();
        return awsCredentialsOptions;
    }

    private void attachUserCredentials(RestClientBuilder restClientBuilder) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this.authConfig != null) {
            if (this.authConfig.getUsername() != null) {
                LOG.info("Using the authentication provided in the config.");
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.authConfig.getUsername(), this.authConfig.getPassword()));
            }
        } else if (this.username != null) {
            LOG.info("Using the username provided in the config.");
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        }
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> this.lambda$attachUserCredentials$3((CredentialsProvider)credentialsProvider, arg_0));
    }

    private void setHttpProxyIfApplicable(HttpAsyncClientBuilder httpClientBuilder) {
        this.proxy.ifPresent(p -> {
            HttpHost httpProxyHost = HttpHost.create((String)p);
            this.checkProxyPort(httpProxyHost.getPort());
            httpClientBuilder.setProxy(httpProxyHost);
        });
    }

    private void checkProxyPort(int port) {
        if (!VALID_PORT_RANGE.isValidIntValue(port)) {
            throw new IllegalArgumentException("Invalid or missing proxy port.");
        }
    }

    private void attachSSLContext(HttpAsyncClientBuilder httpClientBuilder) {
        SSLContext sslContext = this.certPath != null ? this.getCAStrategy(this.certPath) : (this.insecure ? this.getTrustAllStrategy() : null);
        if (sslContext != null) {
            httpClientBuilder.setSSLContext(sslContext);
        }
        if (this.insecure) {
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
    }

    private SSLContext getCAStrategy(Path certPath) {
        LOG.info("Using the cert provided in the config.");
        try {
            Certificate trustedCa;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            try (InputStream is = Files.newInputStream(certPath, new OpenOption[0]);){
                trustedCa = factory.generateCertificate(is);
            }
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
            return sslContextBuilder.build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private SSLContext getTrustAllStrategy() {
        LOG.info("Using the trust all strategy");
        TrustAllStrategy trustStrategy = new TrustAllStrategy();
        try {
            return SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)trustStrategy).build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public OpenSearchClient createOpenSearchClient(RestHighLevelClient restHighLevelClient, AwsCredentialsSupplier awsCredentialsSupplier) {
        return new OpenSearchClient(this.createOpenSearchTransport(restHighLevelClient, awsCredentialsSupplier));
    }

    private OpenSearchTransport createOpenSearchTransport(RestHighLevelClient restHighLevelClient, AwsCredentialsSupplier awsCredentialsSupplier) {
        if (this.awsSigv4) {
            AwsCredentialsOptions awsCredentialsOptions = this.createAwsCredentialsOptions();
            AwsCredentialsProvider credentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
            String serviceName = this.serverless ? AOSS_SERVICE_NAME : AOS_SERVICE_NAME;
            AwsSdk2TransportOptions.Builder transportOptions = AwsSdk2TransportOptions.builder().setCredentials(credentialsProvider).setMapper((JsonpMapper)new PreSerializedJsonpMapper());
            if (!this.isRequestCompressionEnabled()) {
                transportOptions.setRequestCompressionSize(Integer.valueOf(Integer.MAX_VALUE));
            }
            return new AwsSdk2Transport(this.createSdkHttpClient(), HttpHost.create((String)this.hosts.get(0)).toHostString(), serviceName, Region.of((String)this.awsRegion), transportOptions.build());
        }
        return new RestClientTransport(restHighLevelClient.getLowLevelClient(), (JsonpMapper)new PreSerializedJsonpMapper());
    }

    private SdkHttpClient createSdkHttpClient() {
        ApacheHttpClient.Builder apacheHttpClientBuilder = ApacheHttpClient.builder();
        if (this.connectTimeout != null) {
            apacheHttpClientBuilder.connectionTimeout(Duration.ofMillis(this.connectTimeout.intValue()));
        }
        if (this.socketTimeout != null) {
            apacheHttpClientBuilder.socketTimeout(Duration.ofMillis(this.socketTimeout.intValue()));
        }
        this.attachSSLContext(apacheHttpClientBuilder);
        this.setHttpProxyIfApplicable(apacheHttpClientBuilder);
        return apacheHttpClientBuilder.build();
    }

    private void attachSSLContext(ApacheHttpClient.Builder apacheHttpClientBuilder) {
        TrustManager[] trustManagers = ConnectionConfiguration.createTrustManagers(this.certPath, this.insecure);
        if (trustManagers.length > 0) {
            apacheHttpClientBuilder.tlsTrustManagersProvider(() -> trustManagers);
        }
    }

    private static TrustManager[] createTrustManagers(Path certPath, boolean insecure) {
        if (certPath != null) {
            TrustManager[] trustManagerArray;
            block10: {
                LOG.info("Using the cert provided in the config.");
                InputStream certificateInputStream = Files.newInputStream(certPath, new OpenOption[0]);
                try {
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    Certificate trustedCa = factory.generateCertificate(certificateInputStream);
                    KeyStore trustStore = KeyStore.getInstance("pkcs12");
                    trustStore.load(null, null);
                    trustStore.setCertificateEntry("ca", trustedCa);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
                    trustManagerFactory.init(trustStore);
                    trustManagerArray = trustManagerFactory.getTrustManagers();
                    if (certificateInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (certificateInputStream != null) {
                            try {
                                certificateInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                }
                certificateInputStream.close();
            }
            return trustManagerArray;
        }
        if (insecure) {
            LOG.info("Using the trust all strategy");
            return new TrustManager[]{new X509TrustAllManager()};
        }
        return new TrustManager[0];
    }

    private void setHttpProxyIfApplicable(ApacheHttpClient.Builder apacheHttpClientBuilder) {
        this.proxy.ifPresent(p -> {
            URI endpoint = URI.create(p);
            ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(endpoint).build();
            this.checkProxyPort(endpoint.getPort());
            apacheHttpClientBuilder.proxyConfiguration(proxyConfiguration);
        });
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$attachUserCredentials$3(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.apitoken != null) {
            LOG.info("Adding authorization header from auth config.");
            httpClientBuilder.addInterceptorLast((request, context) -> request.addHeader("Authorization", "bearer " + this.apitoken));
        }
        this.attachSSLContext(httpClientBuilder);
        this.setHttpProxyIfApplicable(httpClientBuilder);
        return httpClientBuilder;
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$attachSigV4$1(HttpRequestInterceptor httpRequestInterceptor, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.addInterceptorLast(httpRequestInterceptor);
        this.attachSSLContext(httpClientBuilder);
        this.setHttpProxyIfApplicable(httpClientBuilder);
        return httpClientBuilder;
    }

    public static class Builder {
        private final List<String> hosts;
        private String username;
        private String password;
        private String apitoken;
        private Integer socketTimeout;
        private Integer connectTimeout;
        private Path certPath;
        private boolean insecure;
        private boolean awsSigv4;
        private String awsRegion;
        private String awsStsRoleArn;
        private String awsStsExternalId;
        private Map<String, String> awsStsHeaderOverrides;
        private Optional<String> proxy = Optional.empty();
        private String pipelineName;
        private boolean serverless;
        private String serverlessNetworkPolicyName;
        private String serverlessCollectionName;
        private String serverlessVpceId;
        private boolean requestCompressionEnabled;
        private AuthConfig authConfig;

        private void validateStsRoleArn(String awsStsRoleArn) {
            Arn arn = this.getArn(awsStsRoleArn);
            if (!ConnectionConfiguration.AWS_IAM.equals(arn.service())) {
                throw new IllegalArgumentException("sts_role_arn must be an IAM Role");
            }
            Optional resourceType = arn.resource().resourceType();
            if (resourceType.isEmpty() || !((String)resourceType.get()).equals(ConnectionConfiguration.AWS_IAM_ROLE)) {
                throw new IllegalArgumentException("sts_role_arn must be an IAM Role");
            }
        }

        private Arn getArn(String awsStsRoleArn) {
            try {
                return Arn.fromString((String)awsStsRoleArn);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid ARN format for awsStsRoleArn. Check the format of %s", awsStsRoleArn));
            }
        }

        public Builder(List<String> hosts) {
            Preconditions.checkArgument((hosts != null ? 1 : 0) != 0, (Object)"hosts cannot be null");
            Preconditions.checkArgument((hosts.size() > 0 ? 1 : 0) != 0, (Object)"hosts cannot be empty list");
            this.hosts = hosts;
        }

        public Builder withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username cannot be null");
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password cannot be null");
            this.password = password;
            return this;
        }

        public Builder withApitoken(String apitoken) {
            Preconditions.checkArgument((apitoken != null ? 1 : 0) != 0, (Object)"apitoken cannot be null");
            this.apitoken = apitoken;
            return this;
        }

        public Builder withSocketTimeout(Integer socketTimeout) {
            Preconditions.checkArgument((socketTimeout != null ? 1 : 0) != 0, (Object)"socketTimeout cannot be null");
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withConnectTimeout(Integer connectTimeout) {
            Preconditions.checkArgument((connectTimeout != null ? 1 : 0) != 0, (Object)"connectTimeout cannot be null");
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withCert(String certPath) {
            Preconditions.checkArgument((certPath != null ? 1 : 0) != 0, (Object)"cert cannot be null");
            this.certPath = new File(certPath).toPath();
            return this;
        }

        public Builder withInsecure(boolean insecure) {
            this.insecure = insecure;
            return this;
        }

        public Builder withAwsSigv4(boolean awsSigv4) {
            this.awsSigv4 = awsSigv4;
            return this;
        }

        public Builder withAwsRegion(String awsRegion) {
            Preconditions.checkNotNull((Object)awsRegion, (Object)"awsRegion cannot be null");
            this.awsRegion = awsRegion;
            return this;
        }

        public Builder withAWSStsRoleArn(String awsStsRoleArn) {
            Preconditions.checkArgument((awsStsRoleArn == null || awsStsRoleArn.length() <= 2048 ? 1 : 0) != 0, (Object)"awsStsRoleArn length cannot exceed 2048");
            if (awsStsRoleArn != null) {
                this.validateStsRoleArn(awsStsRoleArn);
            }
            this.awsStsRoleArn = awsStsRoleArn;
            return this;
        }

        public Builder withAWSStsExternalId(String awsStsExternalId) {
            Preconditions.checkArgument((awsStsExternalId == null || awsStsExternalId.length() <= 1224 ? 1 : 0) != 0, (Object)"awsStsExternalId length cannot exceed 1224");
            this.awsStsExternalId = awsStsExternalId;
            return this;
        }

        public Builder withAwsStsHeaderOverrides(Map<String, String> headerOverrides) {
            if (headerOverrides != null && !headerOverrides.isEmpty()) {
                this.awsStsHeaderOverrides = headerOverrides;
            }
            return this;
        }

        public Builder withProxy(String proxy) {
            this.proxy = Optional.ofNullable(proxy);
            return this;
        }

        public Builder withServerless(boolean serverless) {
            this.serverless = serverless;
            return this;
        }

        public Builder withServerlessNetworkPolicyName(String serverlessNetworkPolicyName) {
            this.serverlessNetworkPolicyName = serverlessNetworkPolicyName;
            return this;
        }

        public Builder withServerlessCollectionName(String serverlessCollectionName) {
            this.serverlessCollectionName = serverlessCollectionName;
            return this;
        }

        public Builder withServerlessVpceId(String serverlessVpceId) {
            this.serverlessVpceId = serverlessVpceId;
            return this;
        }

        public Builder withRequestCompressionEnabled(boolean requestCompressionEnabled) {
            this.requestCompressionEnabled = requestCompressionEnabled;
            return this;
        }

        public Builder withAuthConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public ConnectionConfiguration build() {
            return new ConnectionConfiguration(this);
        }
    }
}

