/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.dynamodb.coordination.state.StreamProgressState;

public class StreamPartition
extends EnhancedSourcePartition<StreamProgressState> {
    public static final String PARTITION_TYPE = "STREAM";
    private final String streamArn;
    private final String shardId;
    private final StreamProgressState state;

    public StreamPartition(String streamArn, String shardId, Optional<StreamProgressState> state) {
        this.streamArn = streamArn;
        this.shardId = shardId;
        this.state = state.orElse(null);
    }

    public StreamPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.streamArn = keySplits[0];
        this.shardId = keySplits[1];
        this.state = (StreamProgressState)this.convertStringToPartitionProgressState(StreamProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        return this.streamArn + "|" + this.shardId;
    }

    public Optional<StreamProgressState> getProgressState() {
        if (this.state != null) {
            return Optional.of(this.state);
        }
        return Optional.empty();
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public String getShardId() {
        return this.shardId;
    }
}

