/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.converter;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.Map;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.dynamodb.model.TableInfo;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.OperationType;

public abstract class RecordConverter {
    private static final String DEFAULT_ACTION = OpenSearchBulkActions.INDEX.toString();
    private final BufferAccumulator<Record<Event>> bufferAccumulator;
    private final TableInfo tableInfo;
    static final String TTL_USER_PRINCIPAL = "dynamodb.amazonaws.com";
    static final String TTL_USER_TYPE = "Service";

    public RecordConverter(BufferAccumulator<Record<Event>> bufferAccumulator, TableInfo tableInfo) {
        this.bufferAccumulator = bufferAccumulator;
        this.tableInfo = tableInfo;
    }

    abstract String getEventType();

    private String getAttributeValue(Map<String, Object> data, String attributeName) {
        if (data.containsKey(attributeName)) {
            Object value = data.get(attributeName);
            if (value instanceof Number) {
                return new BigDecimal(value.toString()).toPlainString();
            }
            return String.valueOf(value);
        }
        return null;
    }

    void flushBuffer() throws Exception {
        this.bufferAccumulator.flush();
    }

    public void addToBuffer(AcknowledgementSet acknowledgementSet, Map<String, Object> data, Map<String, Object> keys, long eventCreationTimeMillis, long eventVersionNumber, String eventName, Identity userIdentity) throws Exception {
        JacksonEvent event = JacksonEvent.builder().withEventType(this.getEventType()).withData(data).build();
        if (eventName != null) {
            Instant externalOriginationTime = Instant.ofEpochMilli(eventCreationTimeMillis);
            event.getEventHandle().setExternalOriginationTime(externalOriginationTime);
            event.getMetadata().setExternalOriginationTime(externalOriginationTime);
        }
        EventMetadata eventMetadata = event.getMetadata();
        eventMetadata.setAttribute("table_name", (Object)this.tableInfo.getTableName());
        eventMetadata.setAttribute("dynamodb_timestamp", (Object)eventCreationTimeMillis);
        eventMetadata.setAttribute("dynamodb_event_name", (Object)eventName);
        eventMetadata.setAttribute("opensearch_action", (Object)this.mapStreamEventNameToBulkAction(eventName));
        eventMetadata.setAttribute("document_version", (Object)eventVersionNumber);
        boolean isTtlDelete = OperationType.REMOVE.toString().equals(eventName) && userIdentity != null && TTL_USER_PRINCIPAL.equals(userIdentity.principalId()) && TTL_USER_TYPE.equals(userIdentity.type());
        eventMetadata.setAttribute("ttl_delete", (Object)isTtlDelete);
        String partitionKey = this.getAttributeValue(keys, this.tableInfo.getMetadata().getPartitionKeyAttributeName());
        eventMetadata.setAttribute("partition_key", (Object)partitionKey);
        String sortKey = this.getAttributeValue(keys, this.tableInfo.getMetadata().getSortKeyAttributeName());
        if (sortKey != null) {
            eventMetadata.setAttribute("sort_key", (Object)sortKey);
            eventMetadata.setAttribute("primary_key", (Object)(partitionKey + "|" + sortKey));
        } else {
            eventMetadata.setAttribute("primary_key", (Object)partitionKey);
        }
        if (acknowledgementSet != null) {
            acknowledgementSet.add((Event)event);
        }
        this.bufferAccumulator.add(new Record((Object)event));
    }

    public void addToBuffer(AcknowledgementSet acknowledgementSet, Map<String, Object> data, long timestamp, long eventVersionNumber) throws Exception {
        this.addToBuffer(acknowledgementSet, data, data, timestamp, eventVersionNumber, null, null);
    }

    private String mapStreamEventNameToBulkAction(String streamEventName) {
        if (streamEventName == null) {
            return DEFAULT_ACTION;
        }
        switch (streamEventName) {
            case "INSERT": 
            case "MODIFY": {
                return OpenSearchBulkActions.INDEX.toString();
            }
            case "REMOVE": {
                return OpenSearchBulkActions.DELETE.toString();
            }
        }
        return DEFAULT_ACTION;
    }
}

