/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.types.ByteCount;

class ThresholdConfig {
    @JsonProperty(value="max_events")
    @Min(value=0L, message="max_events must be 0 (unbounded) or greater")
    private @Min(value=0L, message="max_events must be 0 (unbounded) or greater") int maxEvents = 512;
    @JsonProperty(value="max_batch_size")
    private ByteCount maxBatchSize = ByteCount.parse((String)"1mb");
    @JsonProperty(value="flush_timeout")
    @DurationMin(millis=1L, message="flush_timeout must be at least 1ms")
    private @DurationMin(millis=1L, message="flush_timeout must be at least 1ms") Duration flushTimeout = Duration.ofMillis(200L);

    public int getMaxEvents() {
        return this.maxEvents;
    }

    public ByteCount getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration getFlushTimeout() {
        return this.flushTimeout;
    }
}

