/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.script.DynamicMap;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptFactory;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;

public abstract class TermsSetQueryScript {
    public static final String[] PARAMETERS = new String[0];
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("terms_set", Factory.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.opensearch.common.collect.Map.of((Object)"doc", value -> {
        deprecationLogger.deprecate("terms-set-query-script_doc", "Accessing variable [doc] via [params.doc] from within an terms-set-query-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, (Object)"_doc", value -> {
        deprecationLogger.deprecate("terms-set-query-script__doc", "Accessing variable [doc] via [params._doc] from within an terms-set-query-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, (Object)"_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;

    public TermsSetQueryScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new DynamicMap(parameters, PARAMS_FUNCTIONS);
    }

    protected TermsSetQueryScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public long runAsLong() {
        return this.execute().longValue();
    }

    public abstract Number execute();

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public TermsSetQueryScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

