/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.suggest.document.Completion84PostingsFormat;
import org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.FuzzyCompletionQuery;
import org.apache.lucene.search.suggest.document.PrefixCompletionQuery;
import org.apache.lucene.search.suggest.document.RegexCompletionQuery;
import org.apache.lucene.search.suggest.document.SuggestField;
import org.opensearch.Version;
import org.opensearch.common.ParsingException;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.util.set.Sets;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.ArraySourceValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MappingLookup;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TermBasedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.suggest.completion.context.ContextMapping;
import org.opensearch.search.suggest.completion.context.ContextMappings;

public class CompletionFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "completion";
    static final int COMPLETION_CONTEXTS_LIMIT = 10;
    public static final Set<String> ALLOWED_CONTENT_FIELD_NAMES = Sets.newHashSet("input", "weight", "contexts");
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers().get("simple"), c.indexVersionCreated()));
    private final int maxInputLength;
    private final boolean preserveSeparators;
    private final boolean preservePosInc;
    private final NamedAnalyzer defaultAnalyzer;
    private final NamedAnalyzer analyzer;
    private final NamedAnalyzer searchAnalyzer;
    private final ContextMappings contexts;
    private final Version indexVersionCreated;

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.defaultAnalyzer, this.indexVersionCreated).init(this);
    }

    private static CompletionFieldMapper toType(FieldMapper in) {
        return (CompletionFieldMapper)in;
    }

    public CompletionFieldMapper(String simpleName, MappedFieldType mappedFieldType, NamedAnalyzer defaultAnalyzer, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Version indexVersionCreated, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.defaultAnalyzer = defaultAnalyzer;
        this.maxInputLength = (Integer)builder.maxInputLength.getValue();
        this.preserveSeparators = (Boolean)builder.preserveSeparators.getValue();
        this.preservePosInc = (Boolean)builder.preservePosInc.getValue();
        this.analyzer = (NamedAnalyzer)((Object)builder.analyzer.getValue());
        this.searchAnalyzer = (NamedAnalyzer)((Object)builder.searchAnalyzer.getValue());
        this.contexts = (ContextMappings)builder.contexts.getValue();
        this.indexVersionCreated = indexVersionCreated;
    }

    @Override
    public CompletionFieldType fieldType() {
        return (CompletionFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    int getMaxInputLength() {
        return this.maxInputLength;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        Map<Object, Object> inputMap = new HashMap(1);
        if (context.externalValueSet()) {
            inputMap = this.getInputMapFromExternalValue(context);
        } else {
            if (token == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    this.parse(context, token, parser, inputMap);
                }
            } else {
                this.parse(context, token, parser, inputMap);
            }
        }
        for (Map.Entry<Object, Object> entry : inputMap.entrySet()) {
            String input = (String)entry.getKey();
            if (input.trim().isEmpty()) {
                context.addIgnoredField(this.mappedFieldType.name());
                continue;
            }
            if (input.length() > this.maxInputLength) {
                int len = Math.min(this.maxInputLength, input.length());
                if (Character.isHighSurrogate(input.charAt(len - 1))) {
                    assert (input.length() >= len + 1 && Character.isLowSurrogate(input.charAt(len)));
                    ++len;
                }
                input = input.substring(0, len);
            }
            CompletionInputMetadata metadata = (CompletionInputMetadata)entry.getValue();
            if (this.fieldType().hasContextMappings()) {
                this.fieldType().getContextMappings().addField(context.doc(), this.fieldType().name(), input, metadata.weight, metadata.contexts);
                continue;
            }
            context.doc().add((IndexableField)new SuggestField(this.fieldType().name(), input, metadata.weight));
        }
        this.createFieldNamesField(context);
        for (CompletionInputMetadata completionInputMetadata : inputMap.values()) {
            ParseContext externalValueContext = context.createExternalValueContext(completionInputMetadata);
            this.multiFields.parse(this, externalValueContext);
        }
    }

    private Map<String, CompletionInputMetadata> getInputMapFromExternalValue(ParseContext context) {
        Map<String, CompletionInputMetadata> inputMap;
        if (this.isExternalValueOfClass(context, CompletionInputMetadata.class)) {
            CompletionInputMetadata inputAndMeta = (CompletionInputMetadata)context.externalValue();
            inputMap = Collections.singletonMap(inputAndMeta.input, inputAndMeta);
        } else {
            String fieldName = context.externalValue().toString();
            inputMap = Collections.singletonMap(fieldName, new CompletionInputMetadata(fieldName, Collections.emptyMap(), 1));
        }
        return inputMap;
    }

    private boolean isExternalValueOfClass(ParseContext context, Class<?> clazz) {
        return context.externalValue().getClass().equals(clazz);
    }

    private void parse(ParseContext parseContext, XContentParser.Token token, XContentParser parser, Map<String, CompletionInputMetadata> inputMap) throws IOException {
        String currentFieldName = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            inputMap.put(parser.text(), new CompletionInputMetadata(parser.text(), Collections.emptyMap(), 1));
        } else if (token == XContentParser.Token.START_OBJECT) {
            HashSet<String> inputs = new HashSet<String>();
            int weight = 1;
            HashMap<String, Set<String>> contextsMap = new HashMap<String, Set<String>>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (ALLOWED_CONTENT_FIELD_NAMES.contains(currentFieldName)) continue;
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "], must be one of " + ALLOWED_CONTENT_FIELD_NAMES);
                }
                if (currentFieldName == null) continue;
                if ("input".equals(currentFieldName)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        inputs.add(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                inputs.add(parser.text());
                                continue;
                            }
                            throw new IllegalArgumentException("input array must have string values, but was [" + token.name() + "]");
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("input must be a string or array, but was [" + token.name() + "]");
                }
                if ("weight".equals(currentFieldName)) {
                    Number weightValue;
                    if (token == XContentParser.Token.VALUE_STRING) {
                        try {
                            weightValue = Long.parseLong(parser.text());
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("weight must be an integer, but was [" + parser.text() + "]");
                        }
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        XContentParser.NumberType numberType = parser.numberType();
                        if (XContentParser.NumberType.LONG != numberType && XContentParser.NumberType.INT != numberType) {
                            throw new IllegalArgumentException("weight must be an integer, but was [" + parser.numberValue() + "]");
                        }
                        weightValue = parser.numberValue();
                    } else {
                        throw new IllegalArgumentException("weight must be a number or string, but was [" + token.name() + "]");
                    }
                    if (weightValue.longValue() < 0L || weightValue.longValue() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("weight must be in the interval [0..2147483647], but was [" + weightValue.longValue() + "]");
                    }
                    weight = weightValue.intValue();
                    continue;
                }
                if (!"contexts".equals(currentFieldName)) continue;
                if (!this.fieldType().hasContextMappings()) {
                    throw new IllegalArgumentException("contexts field is not supported for field: [" + this.fieldType().name() + "]");
                }
                ContextMappings contextMappings = this.fieldType().getContextMappings();
                XContentParser.Token currentToken = parser.currentToken();
                if (currentToken == XContentParser.Token.START_OBJECT) {
                    ContextMapping<?> contextMapping = null;
                    String fieldName = null;
                    while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (currentToken == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            contextMapping = contextMappings.get(fieldName);
                            continue;
                        }
                        assert (fieldName != null);
                        assert (!contextsMap.containsKey(fieldName));
                        contextsMap.put(fieldName, contextMapping.parseContext(parseContext, parser));
                    }
                    continue;
                }
                throw new IllegalArgumentException("contexts must be an object or an array , but was [" + currentToken + "]");
            }
            for (String input : inputs) {
                if (inputMap.containsKey(input) && inputMap.get((Object)input).weight >= weight) continue;
                inputMap.put(input, new CompletionInputMetadata(input, contextsMap, weight));
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [" + parser.currentName() + "]: expected text or object, but got " + token.name(), new Object[0]);
        }
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void doValidate(MappingLookup mappers) {
        if (this.fieldType().hasContextMappings()) {
            for (ContextMapping<?> contextMapping : this.fieldType().getContextMappings()) {
                contextMapping.validateReferences(this.indexVersionCreated, s -> mappers.fieldTypes().get((String)s));
            }
        }
    }

    static class CompletionInputMetadata {
        public final String input;
        public final Map<String, Set<String>> contexts;
        public final int weight;

        CompletionInputMetadata(String input, Map<String, Set<String>> contexts, int weight) {
            this.input = input;
            this.contexts = contexts;
            this.weight = weight;
        }

        public String toString() {
            return this.input;
        }
    }

    public static final class CompletionFieldType
    extends TermBasedFieldType {
        private static PostingsFormat postingsFormat;
        private boolean preserveSep = true;
        private boolean preservePositionIncrements = true;
        private ContextMappings contextMappings = null;

        public CompletionFieldType(String name, NamedAnalyzer searchAnalyzer, Map<String, String> meta) {
            super(name, true, false, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, searchAnalyzer, searchAnalyzer), meta);
        }

        public void setPreserveSep(boolean preserveSep) {
            this.preserveSep = preserveSep;
        }

        public void setPreservePositionIncrements(boolean preservePositionIncrements) {
            this.preservePositionIncrements = preservePositionIncrements;
        }

        public void setContextMappings(ContextMappings contextMappings) {
            this.contextMappings = contextMappings;
        }

        @Override
        public NamedAnalyzer indexAnalyzer() {
            NamedAnalyzer indexAnalyzer = super.indexAnalyzer();
            if (indexAnalyzer != null && !(indexAnalyzer.analyzer() instanceof CompletionAnalyzer)) {
                return new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, (Analyzer)new CompletionAnalyzer((Analyzer)indexAnalyzer, this.preserveSep, this.preservePositionIncrements));
            }
            return indexAnalyzer;
        }

        public boolean hasContextMappings() {
            return this.contextMappings != null;
        }

        public ContextMappings getContextMappings() {
            return this.contextMappings;
        }

        public static synchronized PostingsFormat postingsFormat() {
            if (postingsFormat == null) {
                postingsFormat = new Completion84PostingsFormat();
            }
            return postingsFormat;
        }

        public CompletionQuery prefixQuery(Object value) {
            return new PrefixCompletionQuery(this.getTextSearchInfo().getSearchAnalyzer().analyzer(), new Term(this.name(), this.indexedValueForSearch(value)));
        }

        public CompletionQuery regexpQuery(Object value, int flags, int maxDeterminizedStates) {
            return new RegexCompletionQuery(new Term(this.name(), this.indexedValueForSearch(value)), flags, maxDeterminizedStates);
        }

        public CompletionQuery fuzzyQuery(String value, Fuzziness fuzziness, int nonFuzzyPrefixLength, int minFuzzyPrefixLength, int maxExpansions, boolean transpositions, boolean unicodeAware) {
            return new FuzzyCompletionQuery(this.getTextSearchInfo().getSearchAnalyzer().analyzer(), new Term(this.name(), this.indexedValueForSearch(value)), null, fuzziness.asDistance(), transpositions, nonFuzzyPrefixLength, minFuzzyPrefixLength, unicodeAware, maxExpansions);
        }

        @Override
        public String typeName() {
            return CompletionFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), mapperService){

                @Override
                protected List<?> parseSourceValue(Object value) {
                    if (value instanceof List) {
                        return (List)value;
                    }
                    return Collections.singletonList(value);
                }
            };
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<NamedAnalyzer> analyzer;
        private final ParametrizedFieldMapper.Parameter<NamedAnalyzer> searchAnalyzer;
        private final ParametrizedFieldMapper.Parameter<Boolean> preserveSeparators = ParametrizedFieldMapper.Parameter.boolParam("preserve_separators", false, m -> CompletionFieldMapper.access$600(CompletionFieldMapper.toType(m)), true).alwaysSerialize();
        private final ParametrizedFieldMapper.Parameter<Boolean> preservePosInc = ParametrizedFieldMapper.Parameter.boolParam("preserve_position_increments", false, m -> CompletionFieldMapper.access$500(CompletionFieldMapper.toType(m)), true).alwaysSerialize();
        private final ParametrizedFieldMapper.Parameter<ContextMappings> contexts = new ParametrizedFieldMapper.Parameter<ContextMappings>("contexts", false, () -> null, (n, c, o) -> ContextMappings.load(o, c.indexVersionCreated()), m -> CompletionFieldMapper.access$400(CompletionFieldMapper.toType(m))).setSerializer((b, n, c) -> {
            if (c == null) {
                return;
            }
            b.startArray(n);
            c.toXContent(b, ToXContent.EMPTY_PARAMS);
            b.endArray();
        }, Objects::toString);
        private final ParametrizedFieldMapper.Parameter<Integer> maxInputLength = ParametrizedFieldMapper.Parameter.intParam("max_input_length", true, m -> CompletionFieldMapper.access$300(CompletionFieldMapper.toType(m)), 50).addDeprecatedName("max_input_len").setValidator(Builder::validateInputLength).alwaysSerialize();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        private final NamedAnalyzer defaultAnalyzer;
        private final Version indexVersionCreated;
        private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Builder.class);

        public Builder(String name, NamedAnalyzer defaultAnalyzer, Version indexVersionCreated) {
            super(name);
            this.defaultAnalyzer = defaultAnalyzer;
            this.indexVersionCreated = indexVersionCreated;
            this.analyzer = ParametrizedFieldMapper.Parameter.analyzerParam("analyzer", false, m -> CompletionFieldMapper.toType(m).analyzer, () -> defaultAnalyzer).alwaysSerialize();
            this.searchAnalyzer = ParametrizedFieldMapper.Parameter.analyzerParam("search_analyzer", true, m -> CompletionFieldMapper.toType(m).searchAnalyzer, this.analyzer::getValue);
        }

        private static void validateInputLength(int maxInputLength) {
            if (maxInputLength <= 0) {
                throw new IllegalArgumentException("[max_input_length] must be > 0 but was [" + maxInputLength + "]");
            }
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.analyzer, this.searchAnalyzer, this.preserveSeparators, this.preservePosInc, this.maxInputLength, this.contexts, this.meta);
        }

        @Override
        public CompletionFieldMapper build(Mapper.BuilderContext context) {
            this.checkCompletionContextsLimit(context);
            NamedAnalyzer completionAnalyzer = new NamedAnalyzer(this.searchAnalyzer.getValue().name(), AnalyzerScope.INDEX, (Analyzer)new CompletionAnalyzer((Analyzer)this.searchAnalyzer.getValue(), this.preserveSeparators.getValue().booleanValue(), this.preservePosInc.getValue().booleanValue()));
            CompletionFieldType ft = new CompletionFieldType(this.buildFullName(context), completionAnalyzer, this.meta.getValue());
            ft.setContextMappings(this.contexts.getValue());
            ft.setPreservePositionIncrements(this.preservePosInc.getValue());
            ft.setPreserveSep(this.preserveSeparators.getValue());
            ft.setIndexAnalyzer(this.analyzer.getValue());
            return new CompletionFieldMapper(this.name, ft, this.defaultAnalyzer, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this.indexVersionCreated, this);
        }

        private void checkCompletionContextsLimit(Mapper.BuilderContext context) {
            if (this.contexts.getValue() != null && this.contexts.getValue().size() > 10) {
                deprecationLogger.deprecate("excessive_completion_contexts", "You have defined more than [10] completion contexts in the mapping for index [" + context.indexSettings().get("index.provided_name") + "]. The maximum allowed number of completion contexts in a mapping will be limited to [" + 10 + "] starting in version [8.0].", new Object[0]);
            }
        }
    }

    public static class Fields {
        public static final String CONTENT_FIELD_NAME_INPUT = "input";
        public static final String CONTENT_FIELD_NAME_WEIGHT = "weight";
        public static final String CONTENT_FIELD_NAME_CONTEXTS = "contexts";
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean DEFAULT_PRESERVE_SEPARATORS = true;
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
        public static final int DEFAULT_MAX_INPUT_LENGTH = 50;

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

