/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;

public class ValidateQueryRequest
extends BroadcastRequest<ValidateQueryRequest>
implements ToXContentObject {
    private QueryBuilder query = new MatchAllQueryBuilder();
    private boolean explain;
    private boolean rewrite;
    private boolean allShards;
    private String[] types = Strings.EMPTY_ARRAY;
    long nowInMillis;

    public ValidateQueryRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public ValidateQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.query = in.readNamedWriteable(QueryBuilder.class);
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
        this.explain = in.readBoolean();
        this.rewrite = in.readBoolean();
        this.allShards = in.readBoolean();
    }

    public ValidateQueryRequest(String ... indices) {
        super(indices);
        this.indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.query == null) {
            validationException = ValidateActions.addValidationError("query cannot be null", validationException);
        }
        return validationException;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public ValidateQueryRequest query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    @Deprecated
    public String[] types() {
        return this.types;
    }

    @Deprecated
    public ValidateQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean explain() {
        return this.explain;
    }

    public void rewrite(boolean rewrite) {
        this.rewrite = rewrite;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    public void allShards(boolean allShards) {
        this.allShards = allShards;
    }

    public boolean allShards() {
        return this.allShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable(this.query);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
        out.writeBoolean(this.explain);
        out.writeBoolean(this.rewrite);
        out.writeBoolean(this.allShards);
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", query[" + this.query + "], explain:" + this.explain + ", rewrite:" + this.rewrite + ", all_shards:" + this.allShards;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("query");
        this.query.toXContent(builder, params);
        return builder.endObject();
    }
}

