/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.parse.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Counter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.plugins.processor.parse.AbstractParseProcessor;
import org.opensearch.dataprepper.plugins.processor.parse.json.ParseJsonProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="parse_json", pluginType=Processor.class, pluginConfigurationType=ParseJsonProcessorConfig.class)
public class ParseJsonProcessor
extends AbstractParseProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ParseJsonProcessor.class);
    private static final String PARSE_ERRORS = "parseErrors";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HandleFailedEventsOption handleFailedEventsOption;
    private final Counter parseErrorsCounter;
    private final int depth;

    @DataPrepperPluginConstructor
    public ParseJsonProcessor(PluginMetrics pluginMetrics, ParseJsonProcessorConfig parseJsonProcessorConfig, ExpressionEvaluator expressionEvaluator, EventKeyFactory eventKeyFactory) {
        super(pluginMetrics, parseJsonProcessorConfig, expressionEvaluator, eventKeyFactory);
        this.handleFailedEventsOption = parseJsonProcessorConfig.getHandleFailedEventsOption();
        this.depth = parseJsonProcessorConfig.getDepth();
        this.parseErrorsCounter = pluginMetrics.counter(PARSE_ERRORS);
    }

    @Override
    protected Optional<Map<String, Object>> readValue(String message, Event context) {
        try {
            HashMap map = (HashMap)this.objectMapper.readValue(message, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            if (this.depth == 0) {
                return Optional.of(map);
            }
            return Optional.of(this.convertNestedObjectToString(map, 1, this.depth));
        }
        catch (JsonProcessingException e) {
            if (this.handleFailedEventsOption.shouldLog()) {
                LOG.error(DataPrepperMarkers.SENSITIVE, "An exception occurred due to invalid JSON while parsing [{}] due to {}", (Object)message, (Object)e.getMessage());
            }
            this.parseErrorsCounter.increment();
            return Optional.empty();
        }
        catch (Exception e) {
            if (this.handleFailedEventsOption.shouldLog()) {
                LOG.error(DataPrepperMarkers.SENSITIVE, "An exception occurred while using the parse_json processor while parsing [{}]", (Object)message, (Object)e);
            }
            this.processingFailuresCounter.increment();
            return Optional.empty();
        }
    }
}

