/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otellogs;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;

public class OTelLogsSourceConfig {
    static final String REQUEST_TIMEOUT = "request_timeout";
    static final String PORT = "port";
    static final String PATH = "path";
    static final String SSL = "ssl";
    static final String USE_ACM_CERT_FOR_SSL = "useAcmCertForSSL";
    static final String ACM_CERT_ISSUE_TIME_OUT_MILLIS = "acmCertIssueTimeOutMillis";
    static final String HEALTH_CHECK_SERVICE = "health_check_service";
    static final String PROTO_REFLECTION_SERVICE = "proto_reflection_service";
    static final String SSL_KEY_CERT_FILE = "sslKeyCertChainFile";
    static final String SSL_KEY_FILE = "sslKeyFile";
    static final String ACM_CERT_ARN = "acmCertificateArn";
    static final String ACM_PRIVATE_KEY_PASSWORD = "acmPrivateKeyPassword";
    static final String AWS_REGION = "awsRegion";
    static final String THREAD_COUNT = "thread_count";
    static final String MAX_CONNECTION_COUNT = "max_connection_count";
    static final String ENABLE_UNFRAMED_REQUESTS = "unframed_requests";
    static final String COMPRESSION = "compression";
    static final String RETRY_INFO = "retry_info";
    static final int DEFAULT_REQUEST_TIMEOUT_MS = 10000;
    static final int DEFAULT_PORT = 21892;
    static final int DEFAULT_THREAD_COUNT = 200;
    static final int DEFAULT_MAX_CONNECTION_COUNT = 500;
    static final boolean DEFAULT_SSL = true;
    static final boolean DEFAULT_ENABLED_UNFRAMED_REQUESTS = false;
    static final boolean DEFAULT_HEALTH_CHECK = false;
    static final boolean DEFAULT_PROTO_REFLECTION_SERVICE = false;
    static final boolean DEFAULT_USE_ACM_CERT_FOR_SSL = false;
    static final int DEFAULT_ACM_CERT_ISSUE_TIME_OUT_MILLIS = 120000;
    private static final String S3_PREFIX = "s3://";
    @JsonProperty(value="request_timeout")
    private int requestTimeoutInMillis = 10000;
    @JsonProperty(value="port")
    private int port = 21892;
    @JsonProperty(value="path")
    @Size(min=1, message="path length should be at least 1")
    private @Size(min=1, message="path length should be at least 1") String path;
    @JsonProperty(value="health_check_service")
    private boolean healthCheck = false;
    @JsonProperty(value="proto_reflection_service")
    private boolean protoReflectionService = false;
    @JsonProperty(value="unframed_requests")
    private boolean enableUnframedRequests = false;
    @JsonProperty(value="ssl")
    private boolean ssl = true;
    @JsonProperty(value="output_format")
    private OTelOutputFormat outputFormat = OTelOutputFormat.OPENSEARCH;
    @JsonProperty(value="useAcmCertForSSL")
    private boolean useAcmCertForSSL = false;
    @JsonProperty(value="acmCertIssueTimeOutMillis")
    private long acmCertIssueTimeOutMillis = 120000L;
    @JsonProperty(value="sslKeyCertChainFile")
    private String sslKeyCertChainFile;
    @JsonProperty(value="sslKeyFile")
    private String sslKeyFile;
    private boolean sslCertAndKeyFileInS3;
    @JsonProperty(value="acmCertificateArn")
    private String acmCertificateArn;
    @JsonProperty(value="acmPrivateKeyPassword")
    private String acmPrivateKeyPassword;
    @JsonProperty(value="awsRegion")
    private String awsRegion;
    @JsonProperty(value="thread_count")
    private int threadCount = 200;
    @JsonProperty(value="max_connection_count")
    private int maxConnectionCount = 500;
    @JsonProperty(value="authentication")
    private PluginModel authentication;
    @JsonProperty(value="compression")
    private CompressionOption compression = CompressionOption.NONE;
    @JsonProperty(value="max_request_length")
    private ByteCount maxRequestLength;
    @JsonProperty(value="retry_info")
    private RetryInfoConfig retryInfo;

    @AssertTrue(message="path should start with /")
    @AssertTrue(message="path should start with /") boolean isPathValid() {
        return this.path == null || this.path.startsWith("/");
    }

    public void validateAndInitializeCertAndKeyFileInS3() {
        boolean certAndKeyFileInS3 = false;
        if (this.useAcmCertForSSL) {
            this.validateSSLArgument(String.format("%s is enabled", USE_ACM_CERT_FOR_SSL), this.acmCertificateArn, ACM_CERT_ARN);
            this.validateSSLArgument(String.format("%s is enabled", USE_ACM_CERT_FOR_SSL), this.awsRegion, AWS_REGION);
        } else if (this.ssl) {
            this.validateSSLCertificateFiles();
            certAndKeyFileInS3 = this.isSSLCertificateLocatedInS3();
            if (certAndKeyFileInS3) {
                this.validateSSLArgument("The certificate and key files are located in S3", this.awsRegion, AWS_REGION);
            }
        }
        this.sslCertAndKeyFileInS3 = certAndKeyFileInS3;
    }

    private void validateSSLArgument(String sslTypeMessage, String argument, String argumentName) {
        if (StringUtils.isEmpty((CharSequence)argument)) {
            throw new IllegalArgumentException(String.format("%s, %s can not be empty or null", sslTypeMessage, argumentName));
        }
    }

    private void validateSSLCertificateFiles() {
        this.validateSSLArgument(String.format("%s is enabled", SSL), this.sslKeyCertChainFile, SSL_KEY_CERT_FILE);
        this.validateSSLArgument(String.format("%s is enabled", SSL), this.sslKeyFile, SSL_KEY_FILE);
    }

    private boolean isSSLCertificateLocatedInS3() {
        return this.sslKeyCertChainFile.toLowerCase().startsWith(S3_PREFIX) && this.sslKeyFile.toLowerCase().startsWith(S3_PREFIX);
    }

    public int getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public OTelOutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasHealthCheck() {
        return this.healthCheck;
    }

    public boolean hasProtoReflectionService() {
        return this.protoReflectionService;
    }

    public boolean enableUnframedRequests() {
        return this.enableUnframedRequests;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public boolean useAcmCertForSSL() {
        return this.useAcmCertForSSL;
    }

    public long getAcmCertIssueTimeOutMillis() {
        return this.acmCertIssueTimeOutMillis;
    }

    public String getSslKeyCertChainFile() {
        return this.sslKeyCertChainFile;
    }

    public String getSslKeyFile() {
        return this.sslKeyFile;
    }

    public String getAcmCertificateArn() {
        return this.acmCertificateArn;
    }

    public String getAcmPrivateKeyPassword() {
        return this.acmPrivateKeyPassword;
    }

    public boolean isSslCertAndKeyFileInS3() {
        return this.sslCertAndKeyFileInS3;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public PluginModel getAuthentication() {
        return this.authentication;
    }

    public CompressionOption getCompression() {
        return this.compression;
    }

    public ByteCount getMaxRequestLength() {
        return this.maxRequestLength;
    }

    public RetryInfoConfig getRetryInfo() {
        return this.retryInfo;
    }

    public void setRetryInfo(RetryInfoConfig retryInfo) {
        this.retryInfo = retryInfo;
    }
}

