/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.JacksonJsonReader;
import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import java.io.IOException;
import java.util.Objects;

final class AzureJsonUtils {
    private static final JsonFactory FACTORY = JsonFactory.builder().build();

    static JsonReader createReader(byte[] json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), json, null, true, options);
    }

    static JsonReader createReader(String json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), null, json, true, options);
    }

    private static JsonParser configureParser(JsonParser parser, JsonOptions options) {
        boolean nonNumericSupported = options == null || options.isNonNumericNumbersSupported();
        return parser.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), nonNumericSupported);
    }

    static JsonReader createReader(JsonParser parser) {
        return new JacksonJsonReader(parser, null, null, false, null);
    }

    private AzureJsonUtils() {
    }
}

