/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.AdditionalPropertiesSchema;
import com.github.erosb.jsonsKema.CompositeSchema;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.ReferenceSchema;
import com.github.erosb.jsonsKema.Schema;
import com.github.erosb.jsonsKema.SchemaNotFoundException;
import com.github.erosb.jsonsKema.SchemaVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/erosb/jsonsKema/TraversingSchemaVisitor;", "P", "Lcom/github/erosb/jsonsKema/SchemaVisitor;", "keys", "", "", "<init>", "([Ljava/lang/String;)V", "remainingKeys", "", "consume", "schema", "Lcom/github/erosb/jsonsKema/Schema;", "key", "cb", "Lkotlin/Function0;", "(Lcom/github/erosb/jsonsKema/Schema;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "visitCompositeSchema", "Lcom/github/erosb/jsonsKema/CompositeSchema;", "(Lcom/github/erosb/jsonsKema/CompositeSchema;)Ljava/lang/Object;", "visitAdditionalPropertiesSchema", "Lcom/github/erosb/jsonsKema/AdditionalPropertiesSchema;", "(Lcom/github/erosb/jsonsKema/AdditionalPropertiesSchema;)Ljava/lang/Object;", "visitReferenceSchema", "Lcom/github/erosb/jsonsKema/ReferenceSchema;", "(Lcom/github/erosb/jsonsKema/ReferenceSchema;)Ljava/lang/Object;", "json-sKema"})
public final class TraversingSchemaVisitor<P>
extends SchemaVisitor<P> {
    @NotNull
    private final List<String> remainingKeys;

    public TraversingSchemaVisitor(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        this.remainingKeys = CollectionsKt.toMutableList((Collection)ArraysKt.asList((Object[])keys));
    }

    private final P consume(Schema schema, String key, Function0<? extends P> cb) {
        if (Intrinsics.areEqual((Object)this.remainingKeys.get(0), (Object)key)) {
            this.remainingKeys.remove(0);
            if (this.remainingKeys.isEmpty()) {
                return (P)schema;
            }
            return (P)cb.invoke();
        }
        throw new SchemaNotFoundException(key, this.remainingKeys.get(0));
    }

    @Override
    @Nullable
    public P visitCompositeSchema(@NotNull CompositeSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (this.remainingKeys.isEmpty()) {
            return (P)schema;
        }
        if (Intrinsics.areEqual((Object)this.remainingKeys.get(0), (Object)"title")) {
            this.remainingKeys.remove(0);
            if (this.remainingKeys.isEmpty()) {
                IJsonString iJsonString = schema.getTitle();
                Intrinsics.checkNotNull((Object)iJsonString);
                return (P)iJsonString.getValue();
            }
            throw new SchemaNotFoundException("cannot traverse keys of string 'title'", "");
        }
        if (Intrinsics.areEqual((Object)this.remainingKeys.get(0), (Object)"properties")) {
            this.remainingKeys.remove(0);
            String propName = this.remainingKeys.remove(0);
            Schema schema2 = schema.getPropertySchemas().get(propName);
            return schema2 != null ? (P)schema2.accept(this) : null;
        }
        return super.visitCompositeSchema(schema);
    }

    @Override
    @Nullable
    public P visitAdditionalPropertiesSchema(@NotNull AdditionalPropertiesSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return this.consume(schema, "additionalProperties", () -> TraversingSchemaVisitor.visitAdditionalPropertiesSchema$lambda$0(this, schema));
    }

    @Override
    @Nullable
    public P visitReferenceSchema(@NotNull ReferenceSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (Intrinsics.areEqual((Object)this.remainingKeys.get(0), (Object)"$ref")) {
            this.remainingKeys.remove(0);
            if (this.remainingKeys.isEmpty()) {
                return (P)schema.getReferredSchema();
            }
            Schema schema2 = schema.getReferredSchema();
            Intrinsics.checkNotNull((Object)schema2);
            return schema2.accept(this);
        }
        throw new SchemaNotFoundException("$ref", this.remainingKeys.get(0));
    }

    private static final Object visitAdditionalPropertiesSchema$lambda$0(TraversingSchemaVisitor this$0, AdditionalPropertiesSchema $schema) {
        return super.visitAdditionalPropertiesSchema($schema);
    }
}

