/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.core.load.RefResolver;
import com.github.fge.jsonschema.core.processing.CachingProcessor;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.processing.ProcessorChain;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.digest.SchemaDigester;
import com.github.fge.jsonschema.processors.format.FormatProcessor;
import com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import com.google.common.base.Equivalence;
import javax.annotation.ParametersAreNonnullByDefault;

public final class ValidationChain
implements Processor<SchemaContext, ValidatorList> {
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> resolver;
    private final Processor<SchemaContext, ValidatorList> builder;

    public ValidationChain(RefResolver refResolver, Library library, ValidationConfiguration cfg) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(cfg.getSyntaxMessages(), library.getSyntaxCheckers());
        ProcessorChain chain1 = ProcessorChain.startWith((Processor)refResolver).chainWith((Processor)syntaxProcessor);
        this.resolver = new CachingProcessor(chain1.getProcessor(), SchemaHolderEquivalence.INSTANCE, cfg.getCacheSize());
        SchemaDigester digester = new SchemaDigester(library);
        ValidatorBuilder keywordBuilder = new ValidatorBuilder(library);
        ProcessorChain chain2 = ProcessorChain.startWith((Processor)digester).chainWith((Processor)keywordBuilder);
        if (cfg.getUseFormat()) {
            FormatProcessor format = new FormatProcessor(library, cfg);
            chain2 = chain2.chainWith((Processor)format);
        }
        this.builder = new CachingProcessor(chain2.getProcessor(), SchemaContextEquivalence.getInstance(), cfg.getCacheSize());
    }

    public ValidatorList process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        ValueHolder in = ValueHolder.hold((String)"schema", (AsJson)input.getSchema());
        ListProcessingReport r = new ListProcessingReport(report);
        ValueHolder out = (ValueHolder)this.resolver.process((ProcessingReport)r, (MessageProvider)in);
        report.mergeWith((ProcessingReport)r);
        if (!r.isSuccess()) {
            return null;
        }
        SchemaContext output = new SchemaContext((SchemaTree)out.getValue(), input.getInstanceType());
        return (ValidatorList)this.builder.process(report, (MessageProvider)output);
    }

    public String toString() {
        return this.resolver + " -> " + this.builder;
    }

    @ParametersAreNonnullByDefault
    private static final class SchemaHolderEquivalence
    extends Equivalence<ValueHolder<SchemaTree>> {
        private static final Equivalence<ValueHolder<SchemaTree>> INSTANCE = new SchemaHolderEquivalence();

        private SchemaHolderEquivalence() {
        }

        protected boolean doEquivalent(ValueHolder<SchemaTree> a, ValueHolder<SchemaTree> b) {
            return ((SchemaTree)a.getValue()).equals(b.getValue());
        }

        protected int doHash(ValueHolder<SchemaTree> t) {
            return ((SchemaTree)t.getValue()).hashCode();
        }
    }
}

