/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.detect_format;

import java.util.Collection;
import java.util.List;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.detect_format.DetectFormatProcessorConfig;

@DataPrepperPlugin(name="detect_format", pluginType=Processor.class, pluginConfigurationType=DetectFormatProcessorConfig.class)
public class DetectFormatProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private String source;
    private String targetKey;
    private String targetMetadataKey;
    private String detectWhen;
    private List<String> kvSeparatorList;
    private String kvDelimiter;
    private ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public DetectFormatProcessor(DetectFormatProcessorConfig detectFormatProcessorConfig, PluginMetrics pluginMetrics, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.source = detectFormatProcessorConfig.getSource();
        this.targetKey = detectFormatProcessorConfig.getTargetKey();
        this.targetMetadataKey = detectFormatProcessorConfig.getTargetMetadataKey();
        this.detectWhen = detectFormatProcessorConfig.getDetectWhen();
        this.kvSeparatorList = detectFormatProcessorConfig.getKVSeparatorList();
        this.kvDelimiter = detectFormatProcessorConfig.getKVDelimiter();
        this.expressionEvaluator = expressionEvaluator;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        String format = null;
        for (Record<Event> record : records) {
            String sourceData;
            Event recordEvent = (Event)record.getData();
            if (this.detectWhen != null && !this.expressionEvaluator.evaluateConditional(this.detectWhen, recordEvent).booleanValue() || (sourceData = (String)recordEvent.get(this.source, String.class)) == null) continue;
            if ((sourceData = sourceData.trim()).startsWith("{") && sourceData.endsWith("}")) {
                format = "json";
            } else if (sourceData.startsWith("<?xml") || sourceData.startsWith("<") && sourceData.endsWith(">")) {
                format = "xml";
            } else {
                String[] lines = sourceData.split("\r?\n");
                if (lines.length > 1) {
                    long expectedCommas = lines[0].chars().filter(ch -> ch == 44).count();
                    int maxMatches = Math.min(lines.length, 10);
                    int numMatches = 0;
                    for (int i = 1; i < maxMatches; ++i) {
                        long commas = lines[i].chars().filter(ch -> ch == 44).count();
                        if (commas != expectedCommas) continue;
                        ++numMatches;
                    }
                    if (numMatches >= maxMatches / 2) {
                        format = "csv";
                    }
                }
                if (format == null) {
                    for (String kvSeparator : this.kvSeparatorList) {
                        String[] keyValuePairs = lines[0].split(kvSeparator);
                        if (keyValuePairs.length <= 1 || !keyValuePairs[0].contains(this.kvDelimiter)) continue;
                        format = "keyvalue";
                        break;
                    }
                }
            }
            if (format == null) continue;
            if (this.targetKey != null) {
                recordEvent.put(this.targetKey, (Object)format);
            }
            if (this.targetMetadataKey == null) continue;
            recordEvent.getMetadata().setAttribute(this.targetMetadataKey, (Object)format);
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

