/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.translate;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.processor.translate.FileParameterConfig;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsHandler;
import org.opensearch.dataprepper.plugins.processor.translate.MappingsParameterConfig;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>translate</code> processor transforms values in events into preconfigured values.")
public class TranslateProcessorConfig {
    @JsonProperty(value="file")
    @JsonPropertyDescription(value="Points to the file that contains mapping configurations.")
    @Valid
    private FileParameterConfig fileParameterConfig;
    @JsonProperty(value="mappings")
    @JsonPropertyDescription(value="Defines inline mappings.")
    @Valid
    private List<MappingsParameterConfig> mappingsParameterConfigs = new ArrayList<MappingsParameterConfig>();
    @JsonIgnore
    private List<MappingsParameterConfig> fileMappingsConfigs;
    @JsonIgnore
    private List<MappingsParameterConfig> combinedMappingsConfigs;

    public FileParameterConfig getFileParameterConfig() {
        return this.fileParameterConfig;
    }

    public List<MappingsParameterConfig> getMappingsParameterConfigs() {
        return this.mappingsParameterConfigs;
    }

    public List<MappingsParameterConfig> getCombinedMappingsConfigs() {
        return this.combinedMappingsConfigs;
    }

    @AssertTrue(message="Please ensure that at least one of the options, either \"mappings\" or \"file_path\", is properly configured.")
    public @AssertTrue(message="Please ensure that at least one of the options, either \"mappings\" or \"file_path\", is properly configured.") boolean hasMappings() {
        this.isFileValid();
        MappingsHandler handler = new MappingsHandler();
        this.combinedMappingsConfigs = handler.getCombinedMappings(this.mappingsParameterConfigs, this.fileMappingsConfigs);
        return Objects.nonNull(this.combinedMappingsConfigs);
    }

    @AssertTrue(message="\"mappings\" option should not be empty.")
    public @AssertTrue(message="\"mappings\" option should not be empty.") boolean isMappingsValid() {
        return Objects.nonNull(this.mappingsParameterConfigs);
    }

    @AssertTrue(message="The file specified in the \"file_path\" option is not properly configured.")
    public @AssertTrue(message="The file specified in the \"file_path\" option is not properly configured.") boolean isFileValid() {
        if (this.fileParameterConfig == null) {
            return true;
        }
        this.fileMappingsConfigs = this.fileParameterConfig.getFileMappings();
        return Objects.nonNull(this.fileMappingsConfigs);
    }
}

