/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessAsyncClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse;

public class ListSecurityPoliciesPublisher
implements SdkPublisher<ListSecurityPoliciesResponse> {
    private final OpenSearchServerlessAsyncClient client;
    private final ListSecurityPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityPoliciesPublisher(OpenSearchServerlessAsyncClient client, ListSecurityPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityPoliciesPublisher(OpenSearchServerlessAsyncClient client, ListSecurityPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSecurityPoliciesResponseFetcher
    implements AsyncPageFetcher<ListSecurityPoliciesResponse> {
        private ListSecurityPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityPoliciesResponse> nextPage(ListSecurityPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityPoliciesPublisher.this.client.listSecurityPolicies(ListSecurityPoliciesPublisher.this.firstRequest);
            }
            return ListSecurityPoliciesPublisher.this.client.listSecurityPolicies((ListSecurityPoliciesRequest)((Object)ListSecurityPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

