/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.http.codec;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CountingOutputStream;
import com.linecorp.armeria.common.HttpData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.opensearch.dataprepper.http.codec.Codec;

public class JsonCodec
implements Codec<List<String>> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<Map<String, Object>>> LIST_OF_MAP_TYPE_REFERENCE = new TypeReference<List<Map<String, Object>>>(){};
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    @Override
    public List<String> parse(HttpData httpData) throws IOException {
        ArrayList<String> jsonList = new ArrayList<String>();
        List logList = (List)mapper.readValue(httpData.toInputStream(), LIST_OF_MAP_TYPE_REFERENCE);
        for (Map log : logList) {
            String recordString = mapper.writeValueAsString((Object)log);
            jsonList.add(recordString);
        }
        return jsonList;
    }

    @Override
    public void validate(HttpData content) throws IOException {
        mapper.readValue(content.toInputStream(), LIST_OF_MAP_TYPE_REFERENCE);
    }

    @Override
    public void serializeSplit(HttpData content, Consumer<String> serializedBodyConsumer, int splitLength) throws IOException {
        InputStream contentInputStream = content.toInputStream();
        if (splitLength == 0) {
            this.performSerialization(contentInputStream, serializedBodyConsumer, Integer.MAX_VALUE);
        } else {
            this.performSerialization(contentInputStream, serializedBodyConsumer, splitLength);
        }
    }

    private void performSerialization(InputStream inputStream, Consumer<String> serializedBodyConsumer, int splitLength) throws IOException {
        try (JsonParser jsonParser = JSON_FACTORY.createParser(inputStream);){
            if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
                throw new RuntimeException("Input is not a valid JSON array.");
            }
            JsonArrayWriter jsonArrayWriter = new JsonArrayWriter(splitLength, serializedBodyConsumer);
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                JsonGenerator objectJsonGenerator = JSON_FACTORY.createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
                objectJsonGenerator.copyCurrentStructure(jsonParser);
                objectJsonGenerator.close();
                if (jsonArrayWriter.willExceedByWriting(outputStream)) {
                    jsonArrayWriter.close();
                    jsonArrayWriter = new JsonArrayWriter(splitLength, serializedBodyConsumer);
                }
                jsonArrayWriter.write(outputStream);
            }
            jsonArrayWriter.close();
        }
    }

    private static class JsonArrayWriter {
        private static final JsonFactory JSON_FACTORY = new JsonFactory().setCodec((ObjectCodec)mapper);
        private static final int BUFFER_SIZE = 16384;
        private static final String NECESSARY_CHARACTERS_TO_WRITE = ",]";
        private final CountingOutputStream countingOutputStream;
        private final ByteArrayOutputStream outputStream;
        private final int splitLength;
        private final Consumer<String> serializedBodyConsumer;
        private final JsonGenerator generator;
        private boolean hasItem = false;

        JsonArrayWriter(int splitLength, Consumer<String> serializedBodyConsumer) throws IOException {
            this.outputStream = new ByteArrayOutputStream(Math.min(splitLength, 16384));
            this.countingOutputStream = new CountingOutputStream((OutputStream)this.outputStream);
            this.splitLength = splitLength;
            this.serializedBodyConsumer = serializedBodyConsumer;
            this.generator = JSON_FACTORY.createGenerator((OutputStream)this.countingOutputStream, JsonEncoding.UTF8);
            this.generator.writeStartArray();
        }

        boolean willExceedByWriting(ByteArrayOutputStream byteArrayOutputStream) {
            long lengthOfDataWritten;
            int lengthToWrite = byteArrayOutputStream.size();
            return (long)lengthToWrite + (lengthOfDataWritten = this.countingOutputStream.getCount()) + (long)NECESSARY_CHARACTERS_TO_WRITE.length() > (long)this.splitLength;
        }

        void write(ByteArrayOutputStream individualJsonLine) throws IOException {
            String jsonLineString = individualJsonLine.toString(Charset.defaultCharset());
            this.generator.writeRawValue(jsonLineString);
            this.generator.flush();
            this.hasItem = true;
        }

        void close() throws IOException {
            if (this.hasItem) {
                this.generator.writeEndArray();
                this.generator.flush();
                String resultJson = this.outputStream.toString(Charset.defaultCharset());
                this.serializedBodyConsumer.accept(resultJson);
            }
            this.generator.close();
            this.outputStream.close();
        }
    }
}

