/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.fasterxml.jackson.core.JsonPointer;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

class JacksonEventKey
implements EventKey {
    private static final String SEPARATOR = "/";
    private static final int MAX_KEY_LENGTH = 2048;
    private final String key;
    private final EventKeyFactory.EventAction[] eventActions;
    private final String trimmedKey;
    private List<String> keyPathList;
    private JsonPointer jsonPointer;
    private final Set<EventKeyFactory.EventAction> supportedActions;

    JacksonEventKey(String key, EventKeyFactory.EventAction ... eventActions) {
        this(key, false, eventActions);
    }

    JacksonEventKey(String key, boolean lazy, EventKeyFactory.EventAction ... eventActions) {
        EventKeyFactory.EventAction[] eventActionArray;
        this.key = Objects.requireNonNull(key, "Parameter key cannot be null for EventKey.");
        if (eventActions.length == 0) {
            EventKeyFactory.EventAction[] eventActionArray2 = new EventKeyFactory.EventAction[1];
            eventActionArray = eventActionArray2;
            eventActionArray2[0] = EventKeyFactory.EventAction.ALL;
        } else {
            eventActionArray = eventActions;
        }
        this.eventActions = eventActionArray;
        this.supportedActions = EnumSet.noneOf(EventKeyFactory.EventAction.class);
        for (EventKeyFactory.EventAction eventAction : this.eventActions) {
            this.supportedActions.addAll(eventAction.getSupportedActions());
        }
        if (key.isEmpty()) {
            for (EventKeyFactory.EventAction action : this.eventActions) {
                if (!action.isMutableAction()) continue;
                throw new IllegalArgumentException("Event key cannot be an empty string for " + String.valueOf((Object)action) + " actions.");
            }
        }
        this.trimmedKey = this.checkAndTrimKey(key);
        if (!lazy) {
            this.keyPathList = this.toKeyPathList();
            this.jsonPointer = JacksonEventKey.toJsonPointer(this.trimmedKey);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    String getTrimmedKey() {
        return this.trimmedKey;
    }

    List<String> getKeyPathList() {
        if (this.keyPathList == null) {
            this.keyPathList = this.toKeyPathList();
        }
        return this.keyPathList;
    }

    JsonPointer getJsonPointer() {
        if (this.jsonPointer == null) {
            this.jsonPointer = JacksonEventKey.toJsonPointer(this.trimmedKey);
        }
        return this.jsonPointer;
    }

    boolean supports(EventKeyFactory.EventAction eventAction) {
        return this.supportedActions.contains((Object)eventAction);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JacksonEventKey that = (JacksonEventKey)other;
        return Objects.equals(this.key, that.key) && Arrays.equals((Object[])this.eventActions, (Object[])that.eventActions);
    }

    public int hashCode() {
        return Objects.hash(this.key, Arrays.hashCode((Object[])this.eventActions));
    }

    public String toString() {
        return this.key;
    }

    private String checkAndTrimKey(String key) {
        if (!this.supportedActions.equals(Collections.singleton(EventKeyFactory.EventAction.DELETE))) {
            JacksonEventKey.checkKey(key);
        }
        return JacksonEventKey.trimTrailingSlashInKey(key);
    }

    private static void checkKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        if (key.isEmpty()) {
            return;
        }
        if (key.length() > 2048) {
            throw new IllegalArgumentException("key cannot be longer than 2048 characters");
        }
        if (!JacksonEventKey.isValidKey(key)) {
            throw new IllegalArgumentException("key " + key + " must contain only alphanumeric chars with .-_@/ and must follow JsonPointer (ie. 'field/to/key')");
        }
    }

    static String trimTrailingSlashInKey(String key) {
        return key.length() > 1 && key.endsWith(SEPARATOR) ? key.substring(0, key.length() - 1) : key;
    }

    private static boolean isValidKey(String key) {
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '-' || c == '_' || c == '~' || c == '@' || c == '/' || c == '[' || c == ']') continue;
            return false;
        }
        return true;
    }

    private List<String> toKeyPathList() {
        return Collections.unmodifiableList(Arrays.asList(this.trimmedKey.split(SEPARATOR, -1)));
    }

    private static JsonPointer toJsonPointer(String key) {
        Object jsonPointerExpression = key.isEmpty() || key.startsWith(SEPARATOR) ? key : SEPARATOR + key;
        return JsonPointer.compile((String)jsonPointerExpression);
    }

    static boolean isValidEventKey(String key) {
        try {
            JacksonEventKey.checkKey(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

