/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.decompress;

import com.google.common.base.Charsets;
import io.micrometer.core.instrument.Counter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.decompress.DecompressProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.decompress.exceptions.DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="decompress", pluginType=Processor.class, pluginConfigurationType=DecompressProcessorConfig.class)
public class DecompressProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(DecompressProcessor.class);
    static final String DECOMPRESSION_PROCESSING_ERRORS = "processingErrors";
    private final DecompressProcessorConfig decompressProcessorConfig;
    private final ExpressionEvaluator expressionEvaluator;
    private final Counter decompressionProcessingErrors;

    @DataPrepperPluginConstructor
    public DecompressProcessor(PluginMetrics pluginMetrics, DecompressProcessorConfig decompressProcessorConfig, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.decompressProcessorConfig = decompressProcessorConfig;
        this.expressionEvaluator = expressionEvaluator;
        this.decompressionProcessingErrors = pluginMetrics.counter(DECOMPRESSION_PROCESSING_ERRORS);
        if (decompressProcessorConfig.getDecompressWhen() != null && !expressionEvaluator.isValidExpressionStatement(decompressProcessorConfig.getDecompressWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("decompress_when value of %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax.", decompressProcessorConfig.getDecompressWhen()));
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            try {
                if (this.decompressProcessorConfig.getDecompressWhen() != null && !this.expressionEvaluator.evaluateConditional(this.decompressProcessorConfig.getDecompressWhen(), (Event)record.getData()).booleanValue()) continue;
                for (String key : this.decompressProcessorConfig.getKeys()) {
                    String compressedValue = (String)((Event)record.getData()).get(key, String.class);
                    if (compressedValue == null) continue;
                    byte[] compressedValueAsBytes = this.decompressProcessorConfig.getEncodingType().getDecoderEngine().decode(compressedValue);
                    try {
                        InputStream inputStream = this.decompressProcessorConfig.getDecompressionType().getDecompressionEngine().createInputStream((InputStream)new ByteArrayInputStream(compressedValueAsBytes));
                        try {
                            String decompressedString = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
                            ((Event)record.getData()).put(key, (Object)decompressedString);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Unable to decompress key {} using decompression type {}:", new Object[]{key, this.decompressProcessorConfig.getDecompressionType(), e});
                        ((Event)record.getData()).getMetadata().addTags(this.decompressProcessorConfig.getTagsOnFailure());
                        this.decompressionProcessingErrors.increment();
                    }
                }
            }
            catch (DecodingException e) {
                LOG.error("Unable to decode key with base64: {}", (Object)e.getMessage());
                ((Event)record.getData()).getMetadata().addTags(this.decompressProcessorConfig.getTagsOnFailure());
                this.decompressionProcessingErrors.increment();
            }
            catch (Exception e) {
                LOG.error("An uncaught exception occurred while decompressing Events", (Throwable)e);
                ((Event)record.getData()).getMetadata().addTags(this.decompressProcessorConfig.getTagsOnFailure());
                this.decompressionProcessingErrors.increment();
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

