/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse;
import software.amazon.awssdk.services.kafka.model.ReplicatorSummary;

public class ListReplicatorsPublisher
implements SdkPublisher<ListReplicatorsResponse> {
    private final KafkaAsyncClient client;
    private final ListReplicatorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReplicatorsPublisher(KafkaAsyncClient client, ListReplicatorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReplicatorsPublisher(KafkaAsyncClient client, ListReplicatorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReplicatorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReplicatorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReplicatorSummary> replicators() {
        Function<ListReplicatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicators() != null) {
                return response.replicators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReplicatorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReplicatorsResponseFetcher
    implements AsyncPageFetcher<ListReplicatorsResponse> {
        private ListReplicatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListReplicatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReplicatorsResponse> nextPage(ListReplicatorsResponse previousPage) {
            if (previousPage == null) {
                return ListReplicatorsPublisher.this.client.listReplicators(ListReplicatorsPublisher.this.firstRequest);
            }
            return ListReplicatorsPublisher.this.client.listReplicators((ListReplicatorsRequest)((Object)ListReplicatorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

