/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.ProvisionedRequest;
import software.amazon.awssdk.services.kafka.model.ServerlessRequest;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterV2Request
extends KafkaRequest
implements ToCopyableBuilder<Builder, CreateClusterV2Request> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(CreateClusterV2Request.getter(CreateClusterV2Request::clusterName)).setter(CreateClusterV2Request.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateClusterV2Request.getter(CreateClusterV2Request::tags)).setter(CreateClusterV2Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ProvisionedRequest> PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Provisioned").getter(CreateClusterV2Request.getter(CreateClusterV2Request::provisioned)).setter(CreateClusterV2Request.setter(Builder::provisioned)).constructor(ProvisionedRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioned").build()}).build();
    private static final SdkField<ServerlessRequest> SERVERLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Serverless").getter(CreateClusterV2Request.getter(CreateClusterV2Request::serverless)).setter(CreateClusterV2Request.setter(Builder::serverless)).constructor(ServerlessRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverless").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, TAGS_FIELD, PROVISIONED_FIELD, SERVERLESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClusterV2Request.memberNameToFieldInitializer();
    private final String clusterName;
    private final Map<String, String> tags;
    private final ProvisionedRequest provisioned;
    private final ServerlessRequest serverless;

    private CreateClusterV2Request(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.tags = builder.tags;
        this.provisioned = builder.provisioned;
        this.serverless = builder.serverless;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ProvisionedRequest provisioned() {
        return this.provisioned;
    }

    public final ServerlessRequest serverless() {
        return this.serverless;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverless());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterV2Request)) {
            return false;
        }
        CreateClusterV2Request other = (CreateClusterV2Request)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.provisioned(), other.provisioned()) && Objects.equals(this.serverless(), other.serverless());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterV2Request").add("ClusterName", (Object)this.clusterName()).add("Tags", this.hasTags() ? this.tags() : null).add("Provisioned", (Object)this.provisioned()).add("Serverless", (Object)this.serverless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Provisioned": {
                return Optional.ofNullable(clazz.cast(this.provisioned()));
            }
            case "Serverless": {
                return Optional.ofNullable(clazz.cast(this.serverless()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("provisioned", PROVISIONED_FIELD);
        map.put("serverless", SERVERLESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterV2Request, T> g) {
        return obj -> g.apply((CreateClusterV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ProvisionedRequest provisioned;
        private ServerlessRequest serverless;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterV2Request model) {
            super(model);
            this.clusterName(model.clusterName);
            this.tags(model.tags);
            this.provisioned(model.provisioned);
            this.serverless(model.serverless);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final ProvisionedRequest.Builder getProvisioned() {
            return this.provisioned != null ? this.provisioned.toBuilder() : null;
        }

        public final void setProvisioned(ProvisionedRequest.BuilderImpl provisioned) {
            this.provisioned = provisioned != null ? provisioned.build() : null;
        }

        @Override
        public final Builder provisioned(ProvisionedRequest provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final ServerlessRequest.Builder getServerless() {
            return this.serverless != null ? this.serverless.toBuilder() : null;
        }

        public final void setServerless(ServerlessRequest.BuilderImpl serverless) {
            this.serverless = serverless != null ? serverless.build() : null;
        }

        @Override
        public final Builder serverless(ServerlessRequest serverless) {
            this.serverless = serverless;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterV2Request build() {
            return new CreateClusterV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterV2Request> {
        public Builder clusterName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder provisioned(ProvisionedRequest var1);

        default public Builder provisioned(Consumer<ProvisionedRequest.Builder> provisioned) {
            return this.provisioned((ProvisionedRequest)((ProvisionedRequest.Builder)ProvisionedRequest.builder().applyMutation(provisioned)).build());
        }

        public Builder serverless(ServerlessRequest var1);

        default public Builder serverless(Consumer<ServerlessRequest.Builder> serverless) {
            return this.serverless((ServerlessRequest)((ServerlessRequest.Builder)ServerlessRequest.builder().applyMutation(serverless)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

