/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret;
import software.amazon.awssdk.services.kafka.model.___listOfUnprocessedScramSecretCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateScramSecretResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, BatchAssociateScramSecretResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(BatchAssociateScramSecretResponse.getter(BatchAssociateScramSecretResponse::clusterArn)).setter(BatchAssociateScramSecretResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<List<UnprocessedScramSecret>> UNPROCESSED_SCRAM_SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedScramSecrets").getter(BatchAssociateScramSecretResponse.getter(BatchAssociateScramSecretResponse::unprocessedScramSecrets)).setter(BatchAssociateScramSecretResponse.setter(Builder::unprocessedScramSecrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedScramSecrets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedScramSecret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, UNPROCESSED_SCRAM_SECRETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAssociateScramSecretResponse.memberNameToFieldInitializer();
    private final String clusterArn;
    private final List<UnprocessedScramSecret> unprocessedScramSecrets;

    private BatchAssociateScramSecretResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.unprocessedScramSecrets = builder.unprocessedScramSecrets;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final boolean hasUnprocessedScramSecrets() {
        return this.unprocessedScramSecrets != null && !(this.unprocessedScramSecrets instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedScramSecret> unprocessedScramSecrets() {
        return this.unprocessedScramSecrets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedScramSecrets() ? this.unprocessedScramSecrets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateScramSecretResponse)) {
            return false;
        }
        BatchAssociateScramSecretResponse other = (BatchAssociateScramSecretResponse)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && this.hasUnprocessedScramSecrets() == other.hasUnprocessedScramSecrets() && Objects.equals(this.unprocessedScramSecrets(), other.unprocessedScramSecrets());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateScramSecretResponse").add("ClusterArn", (Object)this.clusterArn()).add("UnprocessedScramSecrets", this.hasUnprocessedScramSecrets() ? this.unprocessedScramSecrets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "UnprocessedScramSecrets": {
                return Optional.ofNullable(clazz.cast(this.unprocessedScramSecrets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("unprocessedScramSecrets", UNPROCESSED_SCRAM_SECRETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateScramSecretResponse, T> g) {
        return obj -> g.apply((BatchAssociateScramSecretResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String clusterArn;
        private List<UnprocessedScramSecret> unprocessedScramSecrets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateScramSecretResponse model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.unprocessedScramSecrets(model.unprocessedScramSecrets);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final List<UnprocessedScramSecret.Builder> getUnprocessedScramSecrets() {
            List<UnprocessedScramSecret.Builder> result = ___listOfUnprocessedScramSecretCopier.copyToBuilder(this.unprocessedScramSecrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedScramSecrets(Collection<UnprocessedScramSecret.BuilderImpl> unprocessedScramSecrets) {
            this.unprocessedScramSecrets = ___listOfUnprocessedScramSecretCopier.copyFromBuilder(unprocessedScramSecrets);
        }

        @Override
        public final Builder unprocessedScramSecrets(Collection<UnprocessedScramSecret> unprocessedScramSecrets) {
            this.unprocessedScramSecrets = ___listOfUnprocessedScramSecretCopier.copy(unprocessedScramSecrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedScramSecrets(UnprocessedScramSecret ... unprocessedScramSecrets) {
            this.unprocessedScramSecrets(Arrays.asList(unprocessedScramSecrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedScramSecrets(Consumer<UnprocessedScramSecret.Builder> ... unprocessedScramSecrets) {
            this.unprocessedScramSecrets(Stream.of(unprocessedScramSecrets).map(c -> (UnprocessedScramSecret)((UnprocessedScramSecret.Builder)UnprocessedScramSecret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateScramSecretResponse build() {
            return new BatchAssociateScramSecretResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateScramSecretResponse> {
        public Builder clusterArn(String var1);

        public Builder unprocessedScramSecrets(Collection<UnprocessedScramSecret> var1);

        public Builder unprocessedScramSecrets(UnprocessedScramSecret ... var1);

        public Builder unprocessedScramSecrets(Consumer<UnprocessedScramSecret.Builder> ... var1);
    }
}

