/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNodeReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class JsonLoader {
    private static final Pattern INITIAL_SLASH = Pattern.compile("^/+");
    private static final JsonNodeReader READER = new JsonNodeReader();

    private JsonLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromResource(@Nonnull String resource) throws IOException {
        JsonNode ret;
        if (resource == null) {
            throw new NullPointerException();
        }
        if (!resource.startsWith("/")) {
            throw new IllegalArgumentException("resource path does not start with a '/'");
        }
        URL url = JsonLoader.class.getResource(resource);
        if (url == null) {
            ClassLoader classLoader;
            if (Thread.currentThread().getContextClassLoader() != null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            } else if (JsonLoader.class.getClassLoader() != null) {
                classLoader = JsonLoader.class.getClassLoader();
            } else {
                throw new NullPointerException();
            }
            String s = INITIAL_SLASH.matcher(resource).replaceFirst("");
            url = classLoader.getResource(s);
        }
        if (url == null) {
            throw new IOException("resource " + resource + " not found");
        }
        try (InputStream in = null;){
            in = url.openStream();
            ret = READER.fromInputStream(in);
        }
        return ret;
    }

    public static JsonNode fromURL(URL url) throws IOException {
        return READER.fromInputStream(url.openStream());
    }

    public static JsonNode fromPath(String path) throws IOException {
        JsonNode ret;
        try (FileInputStream in = null;){
            in = new FileInputStream(path);
            ret = READER.fromInputStream(in);
        }
        return ret;
    }

    public static JsonNode fromFile(File file) throws IOException {
        JsonNode ret;
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            ret = READER.fromInputStream(in);
        }
        return ret;
    }

    public static JsonNode fromReader(Reader reader) throws IOException {
        return READER.fromReader(reader);
    }

    public static JsonNode fromString(String json) throws IOException {
        return JsonLoader.fromReader(new StringReader(json));
    }
}

