/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.dlq.s3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeyPathGenerator {
    private static final String TIME_PATTERN_INTERNAL_EXTRACTOR_REGULAR_EXPRESSION = "%\\{(.*?)\\}";
    private static final String TIME_PATTERN_STARTING_SYMBOLS = "%{";
    private static final String TIME_PATTERN_REGULAR_EXPRESSION = "%\\{.*?\\}";
    static final ZoneId UTC_ZONE_ID = ZoneId.of(TimeZone.getTimeZone("UTC").getID());
    private static final Set<Character> INVALID_CHARS = ImmutableSet.of((Object)Character.valueOf('#'), (Object)Character.valueOf('\\'), (Object)Character.valueOf('/'), (Object)Character.valueOf('*'), (Object)Character.valueOf('?'), (Object)Character.valueOf('\"'), (Object[])new Character[]{Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf(','), Character.valueOf(':')});
    private static final Set<Character> UNSUPPORTED_TIME_GRANULARITY_CHARS = ImmutableSet.of((Object)Character.valueOf('m'), (Object)Character.valueOf('s'), (Object)Character.valueOf('S'), (Object)Character.valueOf('A'), (Object)Character.valueOf('n'), (Object)Character.valueOf('N'), (Object[])new Character[0]);
    private final String keyPathPrefix;
    private List<DateTimeFormatter> dateFormatters;

    public KeyPathGenerator(String keyPathPrefix) {
        this.keyPathPrefix = keyPathPrefix;
        this.dateFormatters = keyPathPrefix == null ? Collections.emptyList() : this.getDatePatternFormatter(keyPathPrefix);
    }

    public String generate() {
        if (!this.dateFormatters.isEmpty()) {
            ZonedDateTime time = KeyPathGenerator.getCurrentUtcTime();
            AtomicReference<String> kpp = new AtomicReference<String>(this.keyPathPrefix);
            this.dateFormatters.forEach(dateFormatter -> {
                String replacement = dateFormatter.format(time);
                String temp = ((String)kpp.get()).replaceFirst(TIME_PATTERN_REGULAR_EXPRESSION, replacement);
                kpp.set(temp);
            });
            return kpp.get();
        }
        return this.keyPathPrefix;
    }

    private static ZonedDateTime getCurrentUtcTime() {
        return LocalDateTime.now().atZone(ZoneId.systemDefault()).withZoneSameInstant(UTC_ZONE_ID);
    }

    private List<DateTimeFormatter> getDatePatternFormatter(String keyPathPrefix) {
        Pattern pattern = Pattern.compile(TIME_PATTERN_INTERNAL_EXTRACTOR_REGULAR_EXPRESSION);
        Matcher timePatternMatcher = pattern.matcher(keyPathPrefix);
        ImmutableList.Builder patterns = new ImmutableList.Builder();
        while (timePatternMatcher.find()) {
            String timePattern = timePatternMatcher.group(1);
            if (timePattern.contains(TIME_PATTERN_STARTING_SYMBOLS)) {
                throw new IllegalArgumentException("key_path_prefix doesn't allow nested date-time patterns.");
            }
            this.validateNoSpecialCharsInTimePattern(timePattern);
            KeyPathGenerator.validateTimePatternGranularity(timePattern);
            patterns.add((Object)DateTimeFormatter.ofPattern(timePattern));
        }
        return patterns.build();
    }

    private void validateNoSpecialCharsInTimePattern(String timePattern) {
        boolean containsInvalidCharacter = timePattern.chars().mapToObj(c -> Character.valueOf((char)c)).anyMatch(INVALID_CHARS::contains);
        if (containsInvalidCharacter) {
            throw new IllegalArgumentException("key_path_prefix date-time pattern contains one or multiple special characters: " + String.valueOf(INVALID_CHARS));
        }
    }

    private static void validateTimePatternGranularity(String timePattern) {
        boolean containsUnsupportedTimeSymbol = timePattern.chars().mapToObj(c -> Character.valueOf((char)c)).anyMatch(UNSUPPORTED_TIME_GRANULARITY_CHARS::contains);
        if (containsUnsupportedTimeSymbol) {
            throw new IllegalArgumentException("key_path_prefix pattern contains date-time patterns that are less than one day: " + String.valueOf(UNSUPPORTED_TIME_GRANULARITY_CHARS));
        }
    }
}

