/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchIndexProgressState;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.metrics.OpenSearchSourcePluginMetrics;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.NoSearchContextWorker;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.OpenSearchIndexPartitionCreationSupplier;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.PitWorker;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.ScrollWorker;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.SearchWorker;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.ClusterClientFactory;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final Duration EXECUTOR_SERVICE_SHUTDOWN_TIMEOUT = Duration.ofSeconds(30L);
    static final Duration BUFFER_TIMEOUT = Duration.ofSeconds(30L);
    private final SearchAccessor searchAccessor;
    private final OpenSearchSourceConfiguration openSearchSourceConfiguration;
    private final SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator;
    private final Buffer<Record<Event>> buffer;
    private final OpenSearchIndexPartitionCreationSupplier openSearchIndexPartitionCreationSupplier;
    private final ScheduledExecutorService scheduledExecutorService;
    private final BufferAccumulator<Record<Event>> bufferAccumulator;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics;
    private SearchWorker searchWorker;
    private ScheduledFuture<?> searchWorkerFuture;

    public static OpenSearchService createOpenSearchService(SearchAccessor searchAccessor, SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator, OpenSearchSourceConfiguration openSearchSourceConfiguration, Buffer<Record<Event>> buffer, AcknowledgementSetManager acknowledgementSetManager, OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics) {
        return new OpenSearchService(searchAccessor, sourceCoordinator, openSearchSourceConfiguration, buffer, Executors.newSingleThreadScheduledExecutor(), (BufferAccumulator<Record<Event>>)BufferAccumulator.create(buffer, (int)openSearchSourceConfiguration.getSearchConfiguration().getBatchSize(), (Duration)BUFFER_TIMEOUT), acknowledgementSetManager, openSearchSourcePluginMetrics);
    }

    private OpenSearchService(SearchAccessor searchAccessor, SourceCoordinator<OpenSearchIndexProgressState> sourceCoordinator, OpenSearchSourceConfiguration openSearchSourceConfiguration, Buffer<Record<Event>> buffer, ScheduledExecutorService scheduledExecutorService, BufferAccumulator<Record<Event>> bufferAccumulator, AcknowledgementSetManager acknowledgementSetManager, OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics) {
        this.searchAccessor = searchAccessor;
        this.openSearchSourceConfiguration = openSearchSourceConfiguration;
        this.buffer = buffer;
        this.sourceCoordinator = sourceCoordinator;
        this.sourceCoordinator.initialize();
        this.openSearchIndexPartitionCreationSupplier = new OpenSearchIndexPartitionCreationSupplier(openSearchSourceConfiguration, (ClusterClientFactory)((Object)searchAccessor));
        this.scheduledExecutorService = scheduledExecutorService;
        this.bufferAccumulator = bufferAccumulator;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.openSearchSourcePluginMetrics = openSearchSourcePluginMetrics;
    }

    public void start() {
        switch (this.searchAccessor.getSearchContextType()) {
            case POINT_IN_TIME: {
                this.searchWorker = new PitWorker(OBJECT_MAPPER, this.searchAccessor, this.openSearchSourceConfiguration, this.sourceCoordinator, this.bufferAccumulator, this.openSearchIndexPartitionCreationSupplier, this.acknowledgementSetManager, this.openSearchSourcePluginMetrics);
                break;
            }
            case SCROLL: {
                this.searchWorker = new ScrollWorker(OBJECT_MAPPER, this.searchAccessor, this.openSearchSourceConfiguration, this.sourceCoordinator, this.bufferAccumulator, this.openSearchIndexPartitionCreationSupplier, this.acknowledgementSetManager, this.openSearchSourcePluginMetrics);
                break;
            }
            case NONE: {
                this.searchWorker = new NoSearchContextWorker(OBJECT_MAPPER, this.searchAccessor, this.openSearchSourceConfiguration, this.sourceCoordinator, this.bufferAccumulator, this.openSearchIndexPartitionCreationSupplier, this.acknowledgementSetManager, this.openSearchSourcePluginMetrics);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Search context type must be POINT_IN_TIME or SCROLL, type %s was given instead", new Object[]{this.searchAccessor.getSearchContextType()}));
            }
        }
        Instant startTime = this.openSearchSourceConfiguration.getSchedulingParameterConfiguration().getStartTime();
        long waitTimeBeforeStartMillis = startTime.toEpochMilli() - Instant.now().toEpochMilli() < 0L ? 0L : startTime.toEpochMilli() - Instant.now().toEpochMilli();
        LOG.info("The opensearch source will start processing data at {}. It is currently {}", (Object)startTime, (Object)Instant.now());
        this.searchWorkerFuture = this.scheduledExecutorService.schedule(() -> this.searchWorker.run(), waitTimeBeforeStartMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
        try {
            this.searchWorkerFuture.cancel(true);
            if (this.scheduledExecutorService.awaitTermination(EXECUTOR_SERVICE_SHUTDOWN_TIMEOUT.getSeconds(), TimeUnit.SECONDS)) {
                LOG.info("Successfully waited for the search worker to terminate");
            } else {
                LOG.warn("Search worker did not terminate in time, forcing termination");
                this.scheduledExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for the search worker to terminate", (Throwable)e);
            this.scheduledExecutorService.shutdownNow();
        }
    }
}

