/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJsonImpl;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJsonNode;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SizedDocument;

public interface SerializedJson
extends SizedDocument {
    public byte[] getSerializedJson();

    public Optional<String> getDocumentId();

    public Optional<String> getRoutingField();

    public Optional<String> getPipelineField();

    public static SerializedJson fromStringAndOptionals(String jsonString, String docId, String routingField, String pipelineField) {
        Objects.requireNonNull(jsonString);
        return new SerializedJsonImpl(jsonString.getBytes(StandardCharsets.UTF_8), docId, routingField, pipelineField);
    }

    public static SerializedJson fromJsonNode(JsonNode jsonNode, SerializedJson document) {
        return new SerializedJsonNode(jsonNode, document);
    }
}

