/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JakartaJsonObject;
import com.github.wnameless.json.base.JakartaJsonValue;
import com.github.wnameless.json.base.JsonArrayCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.TransformIterator;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Objects;

public final class JakartaJsonArray
implements JsonArrayCore<JakartaJsonValue> {
    private JsonArray jsonArray;

    public JakartaJsonArray(JsonArray jsonArray) {
        if (jsonArray == null) {
            throw new NullPointerException();
        }
        this.jsonArray = jsonArray;
    }

    @Override
    public void add(JsonSource jsonValue) {
        this.jsonArray = Json.createArrayBuilder((JsonArray)this.jsonArray).add((JsonValue)jsonValue.getSource()).build();
    }

    @Override
    public void set(int index, JsonSource jsonValue) {
        this.jsonArray = Json.createArrayBuilder((JsonArray)this.jsonArray).set(index, (JsonValue)jsonValue.getSource()).build();
    }

    @Override
    public JakartaJsonValue remove(int index) {
        JakartaJsonValue value = new JakartaJsonValue((JsonValue)this.jsonArray.get(index));
        this.jsonArray = Json.createArrayBuilder((JsonArray)this.jsonArray).remove(index).build();
        return value;
    }

    @Override
    public JakartaJsonValue get(int index) {
        return new JakartaJsonValue((JsonValue)this.jsonArray.get(index));
    }

    @Override
    public int size() {
        return this.jsonArray.size();
    }

    @Override
    public Iterator<JakartaJsonValue> iterator() {
        return new TransformIterator<JsonValue, JakartaJsonValue>(this.jsonArray.iterator(), JakartaJsonValue::new);
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JakartaJsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JakartaJsonArray asArray() {
        return this;
    }

    @Override
    public JakartaJsonValue asValue() {
        return new JakartaJsonValue((JsonValue)this.jsonArray);
    }

    @Override
    public Object getSource() {
        return this.jsonArray;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JakartaJsonArray)) {
            return false;
        }
        return Objects.equals(this.jsonArray, ((JakartaJsonArray)o).jsonArray);
    }

    public String toString() {
        return this.jsonArray.toString();
    }
}

