/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.certificate.acm;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.model.ExportCertificateRequest;
import software.amazon.awssdk.services.acm.model.ExportCertificateResponse;
import software.amazon.awssdk.services.acm.model.InvalidArnException;
import software.amazon.awssdk.services.acm.model.RequestInProgressException;
import software.amazon.awssdk.services.acm.model.ResourceNotFoundException;

public class ACMCertificateProvider
implements CertificateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ACMCertificateProvider.class);
    private static final long SLEEP_INTERVAL = 10000L;
    private static final int PASSPHRASE_CHAR_COUNT = 36;
    private static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final Random SECURE_RANDOM = new SecureRandom();
    private final AcmClient acmClient;
    private final String acmArn;
    private final long totalTimeout;
    private final String passphrase;

    public ACMCertificateProvider(AcmClient acmClient, String acmArn, long totalTimeout, String passphrase) {
        this.acmClient = Objects.requireNonNull(acmClient);
        this.acmArn = Objects.requireNonNull(acmArn);
        try {
            Arn.fromString((String)acmArn);
        }
        catch (Exception e) {
            throw (InvalidArnException)InvalidArnException.builder().message(String.format("Invalid ARN format for acmArn. Check the format of %s", acmArn)).build();
        }
        this.totalTimeout = Objects.requireNonNull(totalTimeout);
        this.passphrase = passphrase;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Override
    public Certificate getCertificate() {
        long timeSlept;
        ExportCertificateResponse exportCertificateResponse = null;
        String pkPassphrase = Optional.ofNullable(this.passphrase).orElse(this.generatePassphrase(36));
        for (timeSlept = 0L; exportCertificateResponse == null && timeSlept < this.totalTimeout; timeSlept += 10000L) {
            try {
                ExportCertificateRequest exportCertificateRequest = (ExportCertificateRequest)ExportCertificateRequest.builder().certificateArn(this.acmArn).passphrase(SdkBytes.fromByteArray((byte[])pkPassphrase.getBytes())).build();
                exportCertificateResponse = this.acmClient.exportCertificate(exportCertificateRequest);
                continue;
            }
            catch (RequestInProgressException ex) {
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException iex) {
                    throw new RuntimeException(iex);
                }
            }
            catch (InvalidArnException | ResourceNotFoundException ex) {
                LOG.error("Exception retrieving the certificate with arn: {}", (Object)this.acmArn, (Object)ex);
                throw ex;
            }
        }
        if (exportCertificateResponse != null) {
            String decryptedPrivateKey = this.getDecryptedPrivateKey(exportCertificateResponse.privateKey(), pkPassphrase);
            return new Certificate(exportCertificateResponse.certificate(), decryptedPrivateKey);
        }
        throw new IllegalStateException(String.format("Exception retrieving certificate results. Time spent retrieving certificate is %d ms and total time out set is %d ms.", timeSlept, this.totalTimeout));
    }

    private String generatePassphrase(int characterCount) {
        String passphrase = RandomStringUtils.random((int)characterCount, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)SECURE_RANDOM);
        return passphrase;
    }

    private String getDecryptedPrivateKey(String encryptedPrivateKey, String keyPassword) {
        try {
            PrivateKey rsaPrivateKey = this.encryptedPrivateKeyStringToPrivateKey(encryptedPrivateKey, keyPassword.toCharArray());
            return this.privateKeyAsString(rsaPrivateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String privateKeyAsString(PrivateKey key) throws IOException {
        StringWriter sw = new StringWriter();
        try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
            pw.writeObject((Object)key);
        }
        return sw.toString();
    }

    private PrivateKey encryptedPrivateKeyStringToPrivateKey(String encryptedPrivateKey, char[] password) throws IOException, PKCSException {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(encryptedPrivateKey));){
            PrivateKeyInfo pki;
            PKCS8EncryptedPrivateKeyInfo epki;
            Object o = pemParser.readObject();
            if (o instanceof PKCS8EncryptedPrivateKeyInfo) {
                LOG.debug("key in pkcs8 encoding");
                epki = (PKCS8EncryptedPrivateKeyInfo)o;
                JcePKCSPBEInputDecryptorProviderBuilder builder = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(BOUNCY_CASTLE_PROVIDER);
                InputDecryptorProvider idp = builder.build(password);
                pki = epki.decryptPrivateKeyInfo(idp);
            } else if (o instanceof PEMEncryptedKeyPair) {
                LOG.debug("key in pkcs1 encoding");
                epki = (PEMEncryptedKeyPair)o;
                PEMKeyPair pkp = epki.decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(password));
                pki = pkp.getPrivateKeyInfo();
            } else if (o instanceof PEMKeyPair) {
                LOG.debug("key unencrypted");
                PEMKeyPair pkp = (PEMKeyPair)o;
                pki = pkp.getPrivateKeyInfo();
            } else {
                throw new PKCSException("Invalid encrypted private key class: " + String.valueOf(o) != null ? o.getClass().getName() : null);
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(BOUNCY_CASTLE_PROVIDER);
            PrivateKey privateKey = converter.getPrivateKey(pki);
            return privateKey;
        }
    }
}

