/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class SqsQueueUrl {
    private final String accountId;

    private SqsQueueUrl(URL queueUrl) {
        String path = queueUrl.getPath();
        if (path.isEmpty()) {
            throw new IllegalArgumentException("No path for the SQS queue URL.");
        }
        String[] pathParts = path.split("/");
        if (pathParts.length < 3) {
            throw new IllegalArgumentException("Not enough path parts for the SQS queue URL.");
        }
        this.accountId = pathParts[1];
        if (this.accountId.length() != 12) {
            throw new IllegalArgumentException("SQS queue URL has accountId of invalid length.");
        }
        if (!this.accountId.chars().allMatch(Character::isDigit)) {
            throw new IllegalArgumentException("SQS queue URL has accountId with invalid characters.");
        }
    }

    public String getAccountId() {
        return this.accountId;
    }

    public static SqsQueueUrl parse(String queueUrl) throws MalformedURLException {
        Objects.requireNonNull(queueUrl);
        return new SqsQueueUrl(new URL(queueUrl));
    }
}

