/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.export;

import java.time.Instant;
import org.opensearch.dataprepper.plugins.source.dynamodb.utils.DynamoDBSourceAggregateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportFormat;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm;

public class ExportTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExportTaskManager.class);
    private static final ExportFormat DEFAULT_EXPORT_FORMAT = ExportFormat.ION;
    private final DynamoDbClient dynamoDBClient;
    private final DynamoDBSourceAggregateMetrics dynamoAggregateMetrics;

    public ExportTaskManager(DynamoDbClient dynamoDBClient, DynamoDBSourceAggregateMetrics dynamoAggregateMetrics) {
        this.dynamoDBClient = dynamoDBClient;
        this.dynamoAggregateMetrics = dynamoAggregateMetrics;
    }

    public String submitExportJob(String tableArn, String bucket, String prefix, String kmsKeyId, Instant exportTime) {
        S3SseAlgorithm algorithm = kmsKeyId == null || kmsKeyId.isEmpty() ? S3SseAlgorithm.AES256 : S3SseAlgorithm.KMS;
        ExportTableToPointInTimeRequest req = (ExportTableToPointInTimeRequest)ExportTableToPointInTimeRequest.builder().tableArn(tableArn).s3Bucket(bucket).s3Prefix(prefix).s3SseAlgorithm(algorithm).s3SseKmsKeyId(kmsKeyId).exportFormat(DEFAULT_EXPORT_FORMAT).exportTime(exportTime).build();
        try {
            this.dynamoAggregateMetrics.getExportApiInvocations().increment();
            ExportTableToPointInTimeResponse response = this.dynamoDBClient.exportTableToPointInTime(req);
            String exportArn = response.exportDescription().exportArn();
            String status = response.exportDescription().exportStatusAsString();
            LOG.debug("Export Job submitted with ARN {} and status {}", (Object)exportArn, (Object)status);
            return exportArn;
        }
        catch (InternalServerErrorException e) {
            this.dynamoAggregateMetrics.getExport5xxErrors().increment();
            LOG.error("Failed to submit an export job with error: {}", (Object)e.getMessage());
            return null;
        }
        catch (SdkException e) {
            LOG.error("Failed to submit an export job with error " + e.getMessage());
            this.dynamoAggregateMetrics.getExport4xxErrors().increment();
            return null;
        }
    }

    public String getExportManifest(String exportArn) {
        DescribeExportRequest request = (DescribeExportRequest)DescribeExportRequest.builder().exportArn(exportArn).build();
        String manifestKey = null;
        try {
            this.dynamoAggregateMetrics.getExportApiInvocations().increment();
            DescribeExportResponse resp = this.dynamoDBClient.describeExport(request);
            manifestKey = resp.exportDescription().exportManifest();
        }
        catch (InternalServerErrorException e) {
            this.dynamoAggregateMetrics.getExport5xxErrors().increment();
            LOG.error("Unable to get manifest file for export {}: {}", (Object)exportArn, (Object)e.getMessage());
        }
        catch (SdkException e) {
            LOG.error("Unable to get manifest file for export {}: {}", (Object)exportArn, (Object)e.getMessage());
            this.dynamoAggregateMetrics.getExport4xxErrors().increment();
        }
        return manifestKey;
    }

    public String checkExportStatus(String exportArn) {
        DescribeExportRequest request = (DescribeExportRequest)DescribeExportRequest.builder().exportArn(exportArn).build();
        DescribeExportResponse resp = this.dynamoDBClient.describeExport(request);
        String status = resp.exportDescription().exportStatusAsString();
        if (resp.exportDescription().failureCode() != null) {
            LOG.error("Export failed with error: " + resp.exportDescription().failureMessage());
        }
        return status;
    }
}

