/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.summarization;

import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.util.Weighted;
import java.util.List;
import java.util.Random;

public class RCFStringSummarizeExample
implements Example {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_BLUE = "\u001b[34m";

    public static void main(String[] args) throws Exception {
        new RCFStringSummarizeExample().run();
    }

    @Override
    public String command() {
        return "RCF_String_Summarize_Example";
    }

    @Override
    public String description() {
        return "Example of using RCF String Summarization, uses multi-centroid approach";
    }

    @Override
    public void run() throws Exception {
        long seed = -8436172895711381300L;
        new Random().nextLong();
        System.out.println("String summarization seed : " + seed);
        Random random = new Random(seed);
        int size = 100;
        int numberOfStrings = 20000;
        Object[] points = new String[numberOfStrings];
        for (int i = 0; i < numberOfStrings; ++i) {
            points[i] = random.nextDouble() < 0.5 ? this.getABString(size, 0.8, random) : this.getABString(size, 0.2, random);
        }
        int nextSeed = random.nextInt();
        List summary = Summarizer.multiSummarize((Object[])points, (int)5, (int)10, (int)1, (boolean)false, (double)0.8, RCFStringSummarizeExample::toyDistance, (long)nextSeed, (Boolean)true, (double)0.1, (int)5);
        System.out.println();
        for (int i = 0; i < summary.size(); ++i) {
            double weight = ((ICluster)summary.get(i)).getWeight();
            System.out.println("Cluster " + i + " representatives, weight " + (double)Math.round(1000.0 * weight) * 0.001);
            List representatives = ((ICluster)summary.get(i)).getRepresentatives();
            for (int j = 0; j < representatives.size(); ++j) {
                double t = ((Weighted)representatives.get((int)j)).weight;
                t = (double)Math.round(1000.0 * t / weight) * 0.001;
                System.out.print("relative weight " + (float)t + " length " + ((String)((Weighted)representatives.get((int)j)).index).length() + " ");
                RCFStringSummarizeExample.printString((String)((Weighted)representatives.get((int)j)).index);
                System.out.println();
            }
            System.out.println();
        }
    }

    public static double toyDistance(String a, String b) {
        if (a.length() > b.length()) {
            return RCFStringSummarizeExample.toyDistance(b, a);
        }
        double[][] dist = new double[2][b.length() + 1];
        for (int j = 0; j < b.length() + 1; ++j) {
            dist[0][j] = j;
        }
        for (int i = 1; i < a.length() + 1; ++i) {
            int j;
            dist[1][0] = i;
            for (j = 1; j < b.length() + 1; ++j) {
                double t = dist[0][j - 1] + (double)(a.charAt(i - 1) != b.charAt(j - 1) ? 1 : 0);
                dist[1][j] = Math.min(Math.min(t, dist[0][j] + 1.0), dist[1][j - 1] + 1.0);
            }
            for (j = 0; j < b.length() + 1; ++j) {
                dist[0][j] = dist[1][j];
            }
        }
        return dist[1][b.length()];
    }

    public static void printString(String a) {
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == '-') {
                System.out.print(ANSI_RED + a.charAt(i) + ANSI_RESET);
                continue;
            }
            System.out.print(ANSI_BLUE + a.charAt(i) + ANSI_RESET);
        }
    }

    public String getABString(int size, double probabilityOfA, Random random) {
        StringBuilder stringBuilder = new StringBuilder();
        int newSize = size + random.nextInt(size / 5);
        for (int i = 0; i < newSize; ++i) {
            if (random.nextDouble() < probabilityOfA) {
                stringBuilder.append("-");
                continue;
            }
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }
}

