/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import java.util.Arrays;
import java.util.Random;

public class ThresholdedInternalShinglingExample
implements Example {
    public static void main(String[] args) throws Exception {
        new ThresholdedInternalShinglingExample().run();
    }

    @Override
    public String command() {
        return "Thresholded_Multi_Dim_example";
    }

    @Override
    public String description() {
        return "Thresholded Multi Dimensional Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 1;
        long count = 0L;
        int dimensions = baseDimensions * shingleSize;
        TransformMethod transformMethod = TransformMethod.NORMALIZE_DIFFERENCE;
        ThresholdedRandomCutForest forest = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).precision(precision).anomalyRate(0.01).forestMode(ForestMode.STANDARD).weightTime(0.0).transformMethod(transformMethod).normalizeTime(true).outputAfter(32).initialAcceptFraction(0.125).build();
        ThresholdedRandomCutForest second = ThresholdedRandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).precision(precision).anomalyRate(0.01).forestMode(ForestMode.TIME_AUGMENTED).weightTime(0.0).transformMethod(transformMethod).normalizeTime(true).outputAfter(32).initialAcceptFraction(0.125).build();
        forest.setLowerThreshold(1.1);
        second.setLowerThreshold(1.1);
        forest.setHorizon(0.75);
        second.setHorizon(0.75);
        long seed = new Random().nextLong();
        Random noise = new Random(0L);
        System.out.println("seed = " + seed);
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData((int)(dataSize + shingleSize - 1), (int)50, (double)100.0, (double)5.0, (long)seed, (int)baseDimensions);
        int keyCounter = 0;
        for (double[] point : dataWithKeys.data) {
            long timestamp = 100L * count + (long)noise.nextInt(10) - 5L;
            AnomalyDescriptor result = forest.process(point, timestamp);
            AnomalyDescriptor test = second.process(point, timestamp);
            CommonUtils.checkArgument((Math.abs(result.getRCFScore() - test.getRCFScore()) < 1.0E-10 ? 1 : 0) != 0, (String)" error");
            CommonUtils.checkArgument((Math.abs(result.getAnomalyGrade() - test.getAnomalyGrade()) < 1.0E-10 ? 1 : 0) != 0, (String)" error");
            if (keyCounter < dataWithKeys.changeIndices.length && count == (long)dataWithKeys.changeIndices[keyCounter]) {
                System.out.println("timestamp " + count + " CHANGE " + Arrays.toString(dataWithKeys.changes[keyCounter]));
                ++keyCounter;
            }
            if (result.getAnomalyGrade() != 0.0) {
                int i;
                System.out.print("timestamp " + count + " RESULT value " + result.getInternalTimeStamp() + " ");
                for (i = 0; i < baseDimensions; ++i) {
                    System.out.print(result.getCurrentInput()[i] + ", ");
                }
                System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
                if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                    System.out.print(-result.getRelativeIndex() + " steps ago, ");
                }
                if (result.isExpectedValuesPresent()) {
                    if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                        System.out.print("instead of ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getPastValues()[i] + ", ");
                        }
                        System.out.print("expected ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                            if (result.getPastValues()[i] == result.getExpectedValuesList()[0][i]) continue;
                            System.out.print("( " + (result.getPastValues()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                        }
                    } else {
                        System.out.print("expected ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                            if (result.getCurrentInput()[i] == result.getExpectedValuesList()[0][i]) continue;
                            System.out.print("( " + (result.getCurrentInput()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                        }
                    }
                } else {
                    System.out.print("insufficient data to provide expected values");
                }
                System.out.println();
            }
            ++count;
        }
    }
}

