/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.dynamicconfiguration;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import java.time.Duration;
import java.time.Instant;

public class DynamicThroughput
implements Example {
    public static void main(String[] args) throws Exception {
        new DynamicThroughput().run();
    }

    @Override
    public String command() {
        return "dynamic_caching";
    }

    @Override
    public String description() {
        return "serialize a Random Cut Forest as a JSON string";
    }

    @Override
    public void run() throws Exception {
        int dimensions = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_64;
        int dataSize = 10 * sampleSize;
        NormalMixtureTestData testData = new NormalMixtureTestData();
        testData.generateTestData(dataSize, dimensions);
        testData.generateTestData(sampleSize, dimensions);
        for (int i = 0; i < 5; ++i) {
            RandomCutForest forest = RandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
            RandomCutForest forest2 = RandomCutForest.builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
            forest2.setBoundingBoxCacheFraction((double)i * 0.25);
            int anomalies = 0;
            for (double[] point : testData.generateTestData(dataSize, dimensions)) {
                double score2;
                double score = forest.getAnomalyScore(point);
                if (Math.abs(score - (score2 = forest2.getAnomalyScore(point))) > 1.0E-10) {
                    ++anomalies;
                }
                forest.update(point);
                forest2.update(point);
            }
            Instant start = Instant.now();
            for (double[] point : testData.generateTestData(sampleSize, dimensions)) {
                double score2;
                double score = forest.getAnomalyScore(point);
                if (Math.abs(score - (score2 = forest2.getAnomalyScore(point))) > 1.0E-10) {
                    ++anomalies;
                }
                forest.update(point);
                forest2.update(point);
            }
            Instant finish = Instant.now();
            if (anomalies > 0) {
                throw new IllegalStateException("score mismatch");
            }
            System.out.println("So far so good! Caching fraction = " + (double)i * 0.25 + ", Time =" + Duration.between(start, finish).toMillis() + " ms (note only one forest is changing)");
        }
    }
}

