/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.StopWatch;

public class SinkStopWatch {
    private final StopWatch stopWatch = StopWatch.create();
    private final ReentrantLock stopWatchLock = new ReentrantLock();

    public void startIfNotRunning() {
        this.stopWatchLock.lock();
        if (!this.stopWatch.isStarted()) {
            this.start();
        }
        this.stopWatchLock.unlock();
    }

    private void start() {
        this.stopWatchLock.lock();
        this.stopWatch.start();
        this.stopWatchLock.unlock();
    }

    public void stopAndReset() {
        this.stopWatchLock.lock();
        this.stopWatch.stop();
        this.stopWatch.reset();
        this.stopWatch.start();
        this.stopWatchLock.unlock();
    }

    public long getElapsedTimeInSeconds() {
        this.stopWatchLock.lock();
        long time = this.stopWatch.getTime(TimeUnit.SECONDS);
        this.stopWatchLock.unlock();
        return time;
    }
}

