/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.client;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.AwsConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;

public final class CloudWatchLogsClientFactory {
    private CloudWatchLogsClientFactory() {
    }

    public static CloudWatchLogsClient createCwlClient(AwsConfig awsConfig, AwsCredentialsSupplier awsCredentialsSupplier) {
        Region region;
        AwsCredentialsProvider awsCredentialsProvider = awsConfig != null ? awsCredentialsSupplier.getProvider(CloudWatchLogsClientFactory.convertToCredentialOptions(awsConfig)) : awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().build());
        Region region2 = region = awsConfig != null ? awsConfig.getAwsRegion() : (Region)awsCredentialsSupplier.getDefaultRegion().get();
        if (awsCredentialsProvider == null || region == null) {
            return null;
        }
        return (CloudWatchLogsClient)((CloudWatchLogsClientBuilder)((CloudWatchLogsClientBuilder)((CloudWatchLogsClientBuilder)CloudWatchLogsClient.builder().region(region)).credentialsProvider(awsCredentialsProvider)).overrideConfiguration(CloudWatchLogsClientFactory.createOverrideConfiguration())).build();
    }

    private static ClientOverrideConfiguration createOverrideConfiguration() {
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(r -> r.numRetries(Integer.valueOf(5))).build();
    }

    private static AwsCredentialsOptions convertToCredentialOptions(AwsConfig awsConfig) {
        return AwsCredentialsOptions.builder().withRegion(awsConfig.getAwsRegion()).withStsRoleArn(awsConfig.getAwsStsRoleArn()).withStsExternalId(awsConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsConfig.getAwsStsHeaderOverrides()).build();
    }
}

