/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.file.ClassPathHttpVfs;
import com.linecorp.armeria.server.file.FileSystemHttpVfs;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.MediaTypeResolver;
import java.io.File;
import java.nio.file.Path;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface HttpVfs {
    public static HttpVfs of(File rootDir) {
        return HttpVfs.of(Objects.requireNonNull(rootDir, "rootDir").toPath());
    }

    public static HttpVfs of(Path rootDir) {
        return new FileSystemHttpVfs(Objects.requireNonNull(rootDir, "rootDir"));
    }

    public static HttpVfs of(ClassLoader classLoader, String rootDir) {
        return new ClassPathHttpVfs(Objects.requireNonNull(classLoader, "classLoader"), Objects.requireNonNull(rootDir, "rootDir"));
    }

    @Deprecated
    public HttpFile get(Executor var1, String var2, Clock var3, @Nullable String var4, HttpHeaders var5);

    default public HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
        return this.get(fileReadExecutor, path, clock, contentEncoding, additionalHeaders);
    }

    public CompletableFuture<Boolean> canList(Executor var1, String var2);

    public CompletableFuture<List<String>> list(Executor var1, String var2);

    public String meterTag();
}

