/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.aws;

import org.opensearch.dataprepper.model.plugin.FailedToUpdatePluginConfigValueException;
import org.opensearch.dataprepper.model.plugin.PluginConfigVariable;
import org.opensearch.dataprepper.plugins.aws.SecretsSupplier;

public class AwsPluginConfigVariable
implements PluginConfigVariable {
    private final SecretsSupplier secretsSupplier;
    private final String secretId;
    private final String secretKey;
    private final boolean isUpdatable;
    private Object secretValue;

    public AwsPluginConfigVariable(SecretsSupplier secretsSupplier, String secretId, String secretKey, Object secretValue) {
        this.secretsSupplier = secretsSupplier;
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.secretValue = secretValue;
        this.isUpdatable = true;
    }

    public Object getValue() {
        return this.secretValue;
    }

    public void setValue(Object newValue) {
        if (!this.isUpdatable()) {
            throw new FailedToUpdatePluginConfigValueException(String.format("Trying to update a secrets that is not updatable. SecretId: %s SecretKey: %s", this.secretId, this.secretKey));
        }
        this.secretsSupplier.updateValue(this.secretId, this.secretKey, newValue);
        this.secretValue = newValue;
    }

    public void refresh() {
        this.secretsSupplier.refresh(this.secretId);
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }
}

