/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.drop;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.SingleThread;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.drop.DropEventProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.drop.DropEventsWhenCondition;

@SingleThread
@DataPrepperPlugin(name="drop_events", pluginType=Processor.class, pluginConfigurationType=DropEventProcessorConfig.class)
public class DropEventsProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private final DropEventsWhenCondition whenCondition;

    @DataPrepperPluginConstructor
    public DropEventsProcessor(PluginMetrics pluginMetrics, DropEventProcessorConfig dropEventProcessorConfig, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        if (dropEventProcessorConfig.getDropWhen() != null && !expressionEvaluator.isValidExpressionStatement(dropEventProcessorConfig.getDropWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("drop_when \"%s\" is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", dropEventProcessorConfig.getDropWhen()));
        }
        this.whenCondition = new DropEventsWhenCondition.Builder().withDropEventsProcessorConfig(dropEventProcessorConfig).withExpressionEvaluator(expressionEvaluator).build();
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        if (this.whenCondition.isNotAlwaysTrue()) {
            return records.stream().filter(record -> this.whenCondition.isStatementFalseWith((Event)record.getData())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

