/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3;

import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.sink.s3.ExtensionProvider;
import org.opensearch.dataprepper.plugins.sink.s3.S3BucketSelector;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.ObjectKey;

public class KeyGenerator {
    private final S3SinkConfig s3SinkConfig;
    private final S3BucketSelector s3BucketSelector;
    private final ExtensionProvider extensionProvider;
    private final ExpressionEvaluator expressionEvaluator;

    public KeyGenerator(S3SinkConfig s3SinkConfig, S3BucketSelector s3BucketSelector, ExtensionProvider extensionProvider, ExpressionEvaluator expressionEvaluator) {
        this.s3SinkConfig = s3SinkConfig;
        this.s3BucketSelector = s3BucketSelector;
        this.extensionProvider = extensionProvider;
        this.expressionEvaluator = expressionEvaluator;
    }

    public String generateKeyForEvent(Event event) {
        String pathPrefix = this.s3BucketSelector != null ? this.s3BucketSelector.getPathPrefix() : ObjectKey.buildingPathPrefix(this.s3SinkConfig, event, this.expressionEvaluator);
        String namePattern = ObjectKey.objectFileName(this.s3SinkConfig, this.extensionProvider.getExtension(), event, this.expressionEvaluator);
        return !pathPrefix.isEmpty() ? pathPrefix + namePattern : namePattern;
    }
}

