/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\rH\u00c6\u0003JK\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001cJ\u0018\u0010&\u001a\u0004\u0018\u00010\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u0007J\t\u0010,\u001a\u00020\u0007H\u00d6\u0001J\u000e\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u001e\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0013\u0010\u0006\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0013\u0010\b\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000fR\u0013\u0010\f\u001a\u00020\r8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0011R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0012R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/squareup/wire/schema/Service;", "", "type", "Lcom/squareup/wire/schema/ProtoType;", "location", "Lcom/squareup/wire/schema/Location;", "documentation", "", "name", "rpcs", "", "Lcom/squareup/wire/schema/Rpc;", "options", "Lcom/squareup/wire/schema/Options;", "(Lcom/squareup/wire/schema/ProtoType;Lcom/squareup/wire/schema/Location;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/squareup/wire/schema/Options;)V", "()Ljava/lang/String;", "()Lcom/squareup/wire/schema/Location;", "()Lcom/squareup/wire/schema/Options;", "()Ljava/util/List;", "()Lcom/squareup/wire/schema/ProtoType;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "link", "", "linker", "Lcom/squareup/wire/schema/Linker;", "linkOptions", "validate", "retainAll", "schema", "Lcom/squareup/wire/schema/Schema;", "markSet", "Lcom/squareup/wire/schema/MarkSet;", "rpc", "toString", "validateRpcUniqueness", "Companion", "wire-schema"})
public final class Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtoType type;
    @NotNull
    private final Location location;
    @NotNull
    private final String documentation;
    @NotNull
    private final String name;
    @NotNull
    private final List<Rpc> rpcs;
    @NotNull
    private final Options options;

    public Service(@NotNull ProtoType type, @NotNull Location location, @NotNull String documentation, @NotNull String name, @NotNull List<Rpc> rpcs, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(rpcs, (String)"rpcs");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.type = type;
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.rpcs = rpcs;
        this.options = options;
    }

    @JvmName(name="type")
    @NotNull
    public final ProtoType type() {
        return this.type;
    }

    @JvmName(name="location")
    @NotNull
    public final Location location() {
        return this.location;
    }

    @JvmName(name="documentation")
    @NotNull
    public final String documentation() {
        return this.documentation;
    }

    @JvmName(name="name")
    @NotNull
    public final String name() {
        return this.name;
    }

    @JvmName(name="rpcs")
    @NotNull
    public final List<Rpc> rpcs() {
        return this.rpcs;
    }

    @JvmName(name="options")
    @NotNull
    public final Options options() {
        return this.options;
    }

    @Nullable
    public final Rpc rpc(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            for (Object t : (Iterable)this.rpcs) {
                Rpc it = (Rpc)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void link(@NotNull Linker linker) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Linker linker2 = linker;
        linker2 = linker2.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.link(linker2);
        }
    }

    public final void linkOptions(@NotNull Linker linker, boolean validate) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Linker linker2 = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.linkOptions(linker2, validate);
        }
        this.options.link(linker2, this.location, validate);
    }

    public final void validate(@NotNull Linker linker) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Linker linker2 = linker;
        linker2 = linker2.withContext(this);
        this.validateRpcUniqueness(linker2, this.rpcs);
        for (Rpc rpc : this.rpcs) {
            rpc.validate(linker2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateRpcUniqueness(Linker linker, List<Rpc> rpcs) {
        LinkedHashMap nameToRpc = new LinkedHashMap();
        for (Rpc entry : rpcs) {
            Object object;
            void $this$getOrPut$iv;
            Map map = nameToRpc;
            String key$iv = entry.getName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(entry);
        }
        for (Map.Entry entry : ((Map)nameToRpc).entrySet()) {
            StringBuilder stringBuilder;
            String key = (String)entry.getKey();
            Set values = (Set)entry.getValue();
            if (values.size() <= 1) continue;
            StringBuilder $this$validateRpcUniqueness_u24lambda_u2d3 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$validateRpcUniqueness_u24lambda_u2d3.append("mutable rpcs share name " + key + ':');
            Iterable $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void rpc;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Rpc rpc2 = (Rpc)item$iv;
                int index = n;
                boolean bl2 = false;
                $this$validateRpcUniqueness_u24lambda_u2d3.append("\n  " + (index + 1) + ". " + rpc.getName() + " (" + rpc.getLocation() + ')');
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String error = string;
            linker.getErrors().plusAssign(error);
        }
    }

    @Nullable
    public final Service retainAll(@NotNull Schema schema, @NotNull MarkSet markSet) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)markSet, (String)"markSet");
        if (!markSet.contains(this.type)) {
            return null;
        }
        List retainedRpcs = new ArrayList();
        for (Rpc rpc : this.rpcs) {
            Rpc retainedRpc = rpc.retainAll(schema, markSet);
            if (retainedRpc == null || !markSet.contains(ProtoMember.Companion.get(this.type, rpc.getName()))) continue;
            retainedRpcs.add(retainedRpc);
        }
        return new Service(this.type, this.location, this.documentation, this.name, retainedRpcs, this.options.retainAll(schema, markSet));
    }

    @NotNull
    public final ProtoType component1() {
        return this.type;
    }

    @NotNull
    public final Location component2() {
        return this.location;
    }

    @NotNull
    public final String component3() {
        return this.documentation;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final List<Rpc> component5() {
        return this.rpcs;
    }

    @NotNull
    public final Options component6() {
        return this.options;
    }

    @NotNull
    public final Service copy(@NotNull ProtoType type, @NotNull Location location, @NotNull String documentation, @NotNull String name, @NotNull List<Rpc> rpcs, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(rpcs, (String)"rpcs");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new Service(type, location, documentation, name, rpcs, options);
    }

    public static /* synthetic */ Service copy$default(Service service, ProtoType protoType, Location location, String string, String string2, List list, Options options, int n, Object object) {
        if ((n & 1) != 0) {
            protoType = service.type;
        }
        if ((n & 2) != 0) {
            location = service.location;
        }
        if ((n & 4) != 0) {
            string = service.documentation;
        }
        if ((n & 8) != 0) {
            string2 = service.name;
        }
        if ((n & 0x10) != 0) {
            list = service.rpcs;
        }
        if ((n & 0x20) != 0) {
            options = service.options;
        }
        return service.copy(protoType, location, string, string2, list, options);
    }

    @NotNull
    public String toString() {
        return "Service(type=" + this.type + ", location=" + this.location + ", documentation=" + this.documentation + ", name=" + this.name + ", rpcs=" + this.rpcs + ", options=" + this.options + ')';
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.location.hashCode();
        result = result * 31 + this.documentation.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + ((Object)this.rpcs).hashCode();
        result = result * 31 + this.options.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Service)) {
            return false;
        }
        Service service = (Service)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)service.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.location, (Object)service.location)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.documentation, (Object)service.documentation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)service.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.rpcs, service.rpcs)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.options, (Object)service.options);
    }

    @JvmStatic
    @NotNull
    public static final List<Service> fromElements$wire_schema(@Nullable String packageName, @NotNull List<ServiceElement> elements) {
        return Companion.fromElements$wire_schema(packageName, elements);
    }

    @JvmStatic
    @NotNull
    public static final List<ServiceElement> toElements$wire_schema(@NotNull List<Service> services) {
        return Companion.toElements$wire_schema(services);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0001\u00a2\u0006\u0002\b\u000fJ!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0001\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/squareup/wire/schema/Service$Companion;", "", "()V", "fromElement", "Lcom/squareup/wire/schema/Service;", "protoType", "Lcom/squareup/wire/schema/ProtoType;", "element", "Lcom/squareup/wire/schema/internal/parser/ServiceElement;", "fromElement$wire_schema", "fromElements", "", "packageName", "", "elements", "fromElements$wire_schema", "toElements", "services", "toElements$wire_schema", "wire-schema"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Service fromElement$wire_schema(@NotNull ProtoType protoType, @NotNull ServiceElement element) {
            Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List<Rpc> rpcs = Rpc.Companion.fromElements(element.getRpcs());
            Options options = new Options(Options.SERVICE_OPTIONS, element.getOptions());
            return new Service(protoType, element.getLocation(), element.getDocumentation(), element.getName(), rpcs, options);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Service> fromElements$wire_schema(@Nullable String packageName, @NotNull List<ServiceElement> elements) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$map$iv = elements;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void service;
                ServiceElement serviceElement = (ServiceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ProtoType protoType = ProtoType.Companion.get(packageName, service.getName());
                collection.add(Companion.fromElement$wire_schema(protoType, (ServiceElement)service));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<ServiceElement> toElements$wire_schema(@NotNull List<Service> services) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(services, (String)"services");
            Iterable $this$map$iv = services;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void service;
                Service service2 = (Service)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ServiceElement(service.location(), service.name(), service.documentation(), Rpc.Companion.toElements(service.rpcs()), service.options().getElements()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

